Imports System
Imports System.Collections.Generic
Imports System.Text
Imports System.Windows
Imports System.Windows.Controls
Imports System.Windows.Data
Imports System.Windows.Documents
Imports System.Windows.Input
Imports System.Windows.Media
Imports System.Windows.Media.Imaging
Imports System.Windows.Shapes
Imports Atalasoft.Imaging.Wpf
Imports System.Windows.Media.Effects
Imports System.Windows.Media.Animation
Imports Atalasoft.Imaging.Codec


Namespace WpfControlsDemo
    ''' <summary>
    ''' Interaction logic for Window1.xaml
    ''' </summary>

    Partial Public Class Window1 : Inherits System.Windows.Window
        Private _animatedSelection As Boolean
        Private _selectionType As SelectionMouseToolType = SelectionMouseToolType.Rectangle
        Private _autoZoomSelection As Boolean
        Private _centerZoomClicks As Boolean
        Private _selectionAspectRatio As Double
        Private _selectionAspectRatioMode As AspectRatioMode
        Private _toolBehavior As MouseToolBehavior = MouseToolBehavior.ClickAndDrag

        Shared Sub New()
            AtalaDemos.HelperMethods.PopulateDecoders(RegisteredDecoders.Decoders)
        End Sub

        Public Sub New()
            InitializeComponent()
            Me.Viewer.ResolutionScaleMode = ResolutionScaleMode.All
        End Sub


#Region "File Menu"

        Private Sub OnOpenFile(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim dlg As Microsoft.Win32.OpenFileDialog = New Microsoft.Win32.OpenFileDialog()
            dlg.Filter = AtalaDemos.HelperMethods.CreateDialogFilter(True)
            If dlg.ShowDialog(Me).Value Then
                Me.Viewer.Open(dlg.FileName, 0, Nothing)
            End If
        End Sub

        Private Sub OnSaveFile(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim dlg As Microsoft.Win32.SaveFileDialog = New Microsoft.Win32.SaveFileDialog()
            dlg.Filter = AtalaDemos.HelperMethods.CreateDialogFilter(False)
            If dlg.ShowDialog().Value Then
                Me.Viewer.Save(dlg.FileName, AtalaDemos.HelperMethods.GetImageEncoder(dlg.FilterIndex), Nothing)
            End If
        End Sub

        Private Sub OnExit(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Me.Close()
        End Sub

#End Region

#Region "View Menu"

        Private Sub OnAutoZoomClick(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim item As MenuItem = CType(IIf(TypeOf sender Is MenuItem, sender, Nothing), MenuItem)
            If item Is Nothing Then
                Return
            End If

            Me.MenuAutoZoomNone.IsChecked = False
            Me.MenuAutoZoomBestFit.IsChecked = False
            Me.MenuAutoZoomBestFitReduce.IsChecked = False
            Me.MenuAutoZoomFitWidth.IsChecked = False
            Me.MenuAutoZoomFitHeight.IsChecked = False

            item.IsChecked = True

            Dim header As String = CStr(item.Header)
            If header = "None" Then
                Me.Viewer.AutoZoom = AutoZoomMode.None
            ElseIf header = "Best Fit" Then
                Me.Viewer.AutoZoom = AutoZoomMode.BestFit
            ElseIf header = "Best Fit Reduce Only" Then
                Me.Viewer.AutoZoom = AutoZoomMode.BestFitReduceOnly
            ElseIf header = "Fit To Width" Then
                Me.Viewer.AutoZoom = AutoZoomMode.FitToWidth
            ElseIf header = "Fit To Height" Then
                Me.Viewer.AutoZoom = AutoZoomMode.FitToHeight
            End If
        End Sub

        Private Sub OnZoomClick(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim item As MenuItem = CType(IIf(TypeOf sender Is MenuItem, sender, Nothing), MenuItem)
            If item Is Nothing Then
                Return
            End If
            Me.Viewer.Zoom = Double.Parse(CStr(item.Header))
        End Sub

        Private Sub OnCenteredClick(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Me.Viewer.IsCentered = Not Me.Viewer.IsCentered
        End Sub

#End Region

#Region "Tools Menu"

        Private Sub OnUseMultiClick(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim item As MenuItem = TryCast(sender, MenuItem)
            If item Is Nothing Then
                Return
            End If

            If item.IsChecked Then
                _toolBehavior = MouseToolBehavior.MultiClick
            Else
                _toolBehavior = MouseToolBehavior.ClickAndDrag
            End If

            Dim magtool As MagnifierMouseTool = TryCast(Me.Viewer.MouseTool, MagnifierMouseTool)
            If magtool IsNot Nothing Then
                magtool.ToolBehavior = _toolBehavior
                Return
            End If

            Dim zoomtool As ZoomMouseTool = TryCast(Me.Viewer.MouseTool, ZoomMouseTool)
            If zoomtool IsNot Nothing Then
                If _toolBehavior = MouseToolBehavior.MultiClick Then
                    zoomtool.LeftButtonTool = ZoomToolMode.ZoomSelection
                Else
                    zoomtool.LeftButtonTool = ZoomToolMode.ZoomIn
                End If

                zoomtool.ToolBehavior = _toolBehavior
                Return
            End If

            Dim seltool As SelectionMouseTool = TryCast(Me.Viewer.MouseTool, SelectionMouseTool)
            If seltool IsNot Nothing Then
                seltool.ToolBehavior = _toolBehavior
            End If
        End Sub

        Private Sub OnMouseToolClick(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim item As MenuItem = CType(IIf(TypeOf sender Is MenuItem, sender, Nothing), MenuItem)
            If item Is Nothing Then
                Return
            End If

            Me.MenuToolMagnifier.IsChecked = False
            Me.MenuToolNone.IsChecked = False
            Me.MenuToolPan.IsChecked = False
            Me.MenuToolSelection.IsChecked = False
            Me.MenuToolZoom.IsChecked = False
            item.IsChecked = True

            Dim header As String = CStr(item.Header)
            Select Case header
                Case "None"
                    Me.Viewer.MouseTool = Nothing
                Case "Magnifier"
                    Me.Viewer.MouseTool = New MagnifierMouseTool(New Size(120, 120), _toolBehavior, 2, New Pen(New SolidColorBrush(Colors.Black), 1))
                Case "Pan"
                    Me.Viewer.MouseTool = New PanningMouseTool()
                Case "Selection"
                    Dim sel As SelectionMouseTool = New SelectionMouseTool(New Rect(), _selectionType, _toolBehavior, Nothing, Colors.Black, Colors.White, Nothing, True, True, _selectionAspectRatio, _selectionAspectRatioMode, _animatedSelection, New Duration(TimeSpan.FromSeconds(3)), False, Nothing)
                    AddHandler sel.SelectionChanging, AddressOf sel_SelectionChanging
                    Me.Viewer.MouseTool = sel
                Case "Zoom"
                    Me.Viewer.MouseTool = New ZoomMouseTool(0.2, _centerZoomClicks, _autoZoomSelection, MouseToolBehavior.ClickAndDrag, Nothing, Colors.White, Nothing, True)
            End Select
        End Sub

#Region "Selection Tool Menus"

        Private Sub sel_SelectionChanging(ByVal sender As Object, ByVal e As SelectionMouseToolChangedEventArgs)
            Me.statusInfo.Text = "Selection: " & e.Bounds.ToString()
        End Sub

        Private Sub OnSelectionAspectRationChanged(ByVal sender As Object, ByVal e As RoutedEventArgs)
            If _selectionAspectRatio = 0 Then
                _selectionAspectRatio = 1
            Else
                _selectionAspectRatio = 0
            End If

            Dim tool As SelectionMouseTool = CType(IIf(TypeOf Me.Viewer.MouseTool Is SelectionMouseTool, Me.Viewer.MouseTool, Nothing), SelectionMouseTool)
            If Not tool Is Nothing Then
                tool.AspectRatio = _selectionAspectRatio
            End If
            e.Handled = True
        End Sub

        Private Sub OnSelectionTypeClicked(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim item As MenuItem = CType(IIf(TypeOf sender Is MenuItem, sender, Nothing), MenuItem)
            If item Is Nothing Then
                Return
            End If

            _selectionType = CType(System.Enum.Parse(GetType(SelectionMouseToolType), CStr(item.Header)), SelectionMouseToolType)

            Dim tool As SelectionMouseTool = CType(IIf(TypeOf Me.Viewer.MouseTool Is SelectionMouseTool, Me.Viewer.MouseTool, Nothing), SelectionMouseTool)
            If Not tool Is Nothing Then
                tool.Bounds = New Rect()
                tool.SelectionType = _selectionType
            End If
        End Sub

        Private Sub OnAspectRationModeClick(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim item As MenuItem = CType(IIf(TypeOf sender Is MenuItem, sender, Nothing), MenuItem)
            If item Is Nothing Then
                Return
            End If

            _selectionAspectRatioMode = CType(System.Enum.Parse(GetType(AspectRatioMode), CStr(item.Header)), AspectRatioMode)
            Dim tool As SelectionMouseTool = CType(IIf(TypeOf Me.Viewer.MouseTool Is SelectionMouseTool, Me.Viewer.MouseTool, Nothing), SelectionMouseTool)
            If Not tool Is Nothing Then
                tool.AspectRatioCornerMode = _selectionAspectRatioMode
            End If
            e.Handled = True
        End Sub

        Private Sub OnAnimatedSelection(ByVal sender As Object, ByVal e As RoutedEventArgs)
            _animatedSelection = Not _animatedSelection

            Dim tool As SelectionMouseTool = CType(IIf(TypeOf Me.Viewer.MouseTool Is SelectionMouseTool, Me.Viewer.MouseTool, Nothing), SelectionMouseTool)
            If Not tool Is Nothing Then
                tool.IsAnimated = _animatedSelection
            End If
        End Sub

        Private Sub OnMaskedSelection(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim tool As SelectionMouseTool = New SelectionMouseTool()
            tool.IsMasked = True
            Me.Viewer.MouseTool = tool
        End Sub

#End Region

#Region "Zoom Tool Menus"

        Private Sub OnCenterZoomClicks(ByVal sender As Object, ByVal e As RoutedEventArgs)
            _centerZoomClicks = Not _centerZoomClicks

            Dim tool As ZoomMouseTool = CType(IIf(TypeOf Me.Viewer.MouseTool Is ZoomMouseTool, Me.Viewer.MouseTool, Nothing), ZoomMouseTool)
            If Not tool Is Nothing Then
                tool.CenterZoom = _centerZoomClicks
            End If
        End Sub

        Private Sub OnAutoZoomSelection(ByVal sender As Object, ByVal e As RoutedEventArgs)
            _autoZoomSelection = Not _autoZoomSelection

            Dim tool As ZoomMouseTool = CType(IIf(TypeOf Me.Viewer.MouseTool Is ZoomMouseTool, Me.Viewer.MouseTool, Nothing), ZoomMouseTool)
            If Not tool Is Nothing Then
                tool.AutoZoomSelection = _autoZoomSelection
            End If
        End Sub

#End Region

#End Region

#Region "Processing Menu"

        Private Sub OnApplyInvert(ByVal sender As Object, ByVal e As RoutedEventArgs)
            ApplyCommand(New Atalasoft.Imaging.ImageProcessing.Channels.InvertCommand())
        End Sub

        Private Sub OnApplyCrop(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim tool As SelectionMouseTool = CType(IIf(TypeOf Me.Viewer.MouseTool Is SelectionMouseTool, Me.Viewer.MouseTool, Nothing), SelectionMouseTool)
            If tool Is Nothing OrElse tool.IsEmpty Then
                MessageBox.Show("Please use the selection tool to select the crop area.", "No Crop Selection")
                Return
            End If

            Dim rc As Rect = tool.Bounds
            ApplyCommand(New Atalasoft.Imaging.ImageProcessing.CropCommand(New System.Drawing.Rectangle(CInt(rc.X), CInt(rc.Y), CInt(rc.Width), CInt(rc.Height))))
        End Sub

        Private Sub OnApplyMosaic(ByVal sender As Object, ByVal e As RoutedEventArgs)
            ApplyCommand(New Atalasoft.Imaging.ImageProcessing.Effects.MosaicCommand(10))
        End Sub

        Private Sub ApplyCommand(ByVal command As Atalasoft.Imaging.ImageProcessing.ImageCommand)
            Try
                If command Is Nothing Then
                    Return
                End If

                ' If the selection tool is in use and the command
                ' supports region of interest, set it.
                Dim regCmd As Atalasoft.Imaging.ImageProcessing.ImageRegionCommand = CType(IIf(TypeOf command Is Atalasoft.Imaging.ImageProcessing.ImageRegionCommand, command, Nothing), Atalasoft.Imaging.ImageProcessing.ImageRegionCommand)
                If Not regCmd Is Nothing Then
                    regCmd.RegionOfInterest = GetRegionOfInterest()
                End If

                Me.Viewer.ApplyCommand(command)

                ' In case there is a selection used, clear it.
                If Not Me.Viewer.MouseTool Is Nothing Then
                    Me.Viewer.MouseTool.Bounds = New Rect()
                End If
            Catch ex As Exception
                MessageBox.Show("There was an exception while processing a command." & Constants.vbCrLf & Constants.vbCrLf & ex.Message, "Error")
            End Try
        End Sub

        Private Function GetRegionOfInterest() As Atalasoft.Imaging.ImageProcessing.RegionOfInterest
            Dim tool As SelectionMouseTool = CType(IIf(TypeOf Me.Viewer.MouseTool Is SelectionMouseTool, Me.Viewer.MouseTool, Nothing), SelectionMouseTool)
            If tool Is Nothing OrElse tool.IsEmpty Then
                Return Nothing
            Else
                Return tool.GetRegion()
            End If
        End Function

#End Region

#Region "Demos"

        Private Sub ShowReflectionDemo(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim win As ReflectionWindow = New ReflectionWindow()
            win.ShowDialog()
        End Sub

        Private Sub DoEllipseMagnifier(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Me.Viewer.MouseTool = New MagnifierMouseTool(New EllipseGeometry(New Rect(0, 0, 180, 90)), _toolBehavior, 2.0, New Pen(New SolidColorBrush(Colors.Black), 1))
        End Sub

        Private Sub DoFunkyMagnifier(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim geo As PathGeometry = New PathGeometry()
            Dim fig As PathFigure = New PathFigure()
            fig.StartPoint = New Point(30, 120)
            fig.Segments.Add(New LineSegment(New Point(50, 120), True))
            fig.Segments.Add(New LineSegment(New Point(50, 80), True))
            fig.Segments.Add(New ArcSegment(New Point(30, 80), New Size(40, 40), 0, True, SweepDirection.Counterclockwise, True))
            fig.IsClosed = True
            geo.Figures.Add(fig)

            Me.Viewer.MouseTool = New MagnifierMouseTool(geo, _toolBehavior, 2.0, New Pen(New SolidColorBrush(Colors.Red), 1))
        End Sub

        Private Sub OnColorSelectionAnimation(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim tool As SelectionMouseTool = New SelectionMouseTool()
            tool.IsAnimated = True
            Me.Viewer.MouseTool = tool

            Dim ani As ColorAnimation = New ColorAnimation(Colors.Blue, Colors.Red, New Duration(TimeSpan.FromSeconds(2)))
            ani.RepeatBehavior = RepeatBehavior.Forever
            ani.AutoReverse = True

            tool.BeginAnimation(SelectionMouseTool.LineColorProperty, ani)
        End Sub

        Private Sub OnBlurSelection(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Me.Viewer.MouseTool = New SelectionMouseTool(SelectionMouseToolType.Ellipse, MouseToolBehavior.ClickAndDrag, True, New Atalasoft.Imaging.ImageProcessing.Filters.BlurGaussianCommand(3))
        End Sub

        Private Sub OnToggleSelection(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim tool As SelectionMouseTool = CType(IIf(TypeOf Me.Viewer.MouseTool Is SelectionMouseTool, Me.Viewer.MouseTool, Nothing), SelectionMouseTool)
            If tool Is Nothing Then
                Return
            End If

            If tool.ToolBehavior = MouseToolBehavior.ClickAndDrag Then
                tool.ToolBehavior = MouseToolBehavior.MultiClick
            Else
                tool.ToolBehavior = MouseToolBehavior.ClickAndDrag
            End If
        End Sub

#End Region

#Region "AtalaViewer Events"
        Private Sub OnImageChanged(ByVal sender As Object, ByVal e As ImageChangedEventArgs)
            Me.statusInfo.Text = "ImageChanged Event"
            e.Handled = True
        End Sub

        Private Sub OnViewerMouseMove(ByVal sender As Object, ByVal e As ImagePixelEventArgs)
            Dim tool As SelectionMouseTool = CType(IIf(TypeOf Me.Viewer.MouseTool Is SelectionMouseTool, Me.Viewer.MouseTool, Nothing), SelectionMouseTool)
            If tool Is Nothing OrElse tool.Bounds.Width = 0 Then
                Me.statusInfo.Text = "Pixel Position: " & e.Pixel.ToString()
            End If
            e.Handled = True
        End Sub
#End Region

        Private Sub HelpAbout_Click(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs)
            ' Instantiate the dialog box
            Dim dlg As About = New About("About Atalasoft WPF Demo", "WPF Demo")
            dlg.Description = "This is a somewhat simplified WPF version of our very popular DotImage Demo." & vbCrLf & vbCrLf & _
                              "The source code should provide a good working example of how yo use our AtalaImageViewer (the WPF version of our ImageViewer Winforms control) and perform various image processing commands in a WPF application." & vbCrLf & vbCrLf & _
                              "The AtalaImageViewer takes advantage of Atalasoft codecs to Open and Save images and image commands can be applied to the image using the ApplyCommand method. The viewer contains a Source property for a BitmapSource object, making its use in WPF straight forward."
            dlg.Link = "www.atalasoft.com/KB/article.aspx?id=10412"

            ' Configure the dialog box
            dlg.Owner = Me

            ' Open the dialog box modally 
            dlg.ShowDialog()
        End Sub
    End Class
End Namespace