using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using Atalasoft.Imaging.Wpf;
using System.Windows.Media.Effects;
using System.Windows.Media.Animation;
using Atalasoft.Imaging.Codec;


namespace WpfDemo
{
    /// <summary>
    /// Interaction logic for Window1.xaml
    /// </summary>

    public partial class Window1 : System.Windows.Window
    {
        private bool _animatedSelection;
        private SelectionMouseToolType _selectionType = SelectionMouseToolType.Rectangle;
        private bool _autoZoomSelection;
        private bool _centerZoomClicks;
        private double _selectionAspectRatio;
        private AspectRatioMode _selectionAspectRatioMode;
        private MouseToolBehavior _toolBehavior = MouseToolBehavior.ClickAndDrag;

        public Window1()
        {
            InitializeComponent();
            AtalaDemos.HelperMethods.PopulateDecoders(RegisteredDecoders.Decoders);
            this.Viewer.ResolutionScaleMode = ResolutionScaleMode.All;
        }


        #region File Menu

        private void OnOpenFile(object sender, RoutedEventArgs e)
        {
            Microsoft.Win32.OpenFileDialog dlg = new Microsoft.Win32.OpenFileDialog();
            dlg.Filter = AtalaDemos.HelperMethods.CreateDialogFilter(true);
            if (dlg.ShowDialog(this).Value)
                this.Viewer.Open(dlg.FileName, 0, null);
        }

        private void OnSaveFile(object sender, RoutedEventArgs e)
        {
            Microsoft.Win32.SaveFileDialog dlg = new Microsoft.Win32.SaveFileDialog();
            //dlg.Filter = "PNG|*.png";
            dlg.Filter = AtalaDemos.HelperMethods.CreateDialogFilter(false);
            if (dlg.ShowDialog().Value)
                this.Viewer.Save(dlg.FileName, AtalaDemos.HelperMethods.GetImageEncoder(dlg.FilterIndex), null);
        }

        private void OnExit(object sender, RoutedEventArgs e)
        {
            this.Close();
        }

        #endregion

        #region View Menu

        private void OnAutoZoomClick(object sender, RoutedEventArgs e)
        {
            MenuItem item = sender as MenuItem;
            if (item == null) return;

            this.MenuAutoZoomNone.IsChecked = false;
            this.MenuAutoZoomBestFit.IsChecked = false;
            this.MenuAutoZoomBestFitReduce.IsChecked = false;
            this.MenuAutoZoomFitWidth.IsChecked = false;
            this.MenuAutoZoomFitHeight.IsChecked = false;

            item.IsChecked = true;

            string header = (string)item.Header;
            if (header == "None")
                this.Viewer.AutoZoom = AutoZoomMode.None;
            else if (header == "Best Fit")
                this.Viewer.AutoZoom = AutoZoomMode.BestFit;
            else if (header == "Best Fit Reduce Only")
                this.Viewer.AutoZoom = AutoZoomMode.BestFitReduceOnly;
            else if (header == "Fit To Width")
                this.Viewer.AutoZoom = AutoZoomMode.FitToWidth;
            else if (header == "Fit To Height")
                this.Viewer.AutoZoom = AutoZoomMode.FitToHeight;
        }

        private void OnZoomClick(object sender, RoutedEventArgs e)
        {
            MenuItem item = sender as MenuItem;
            if (item == null) return;
            this.Viewer.Zoom = double.Parse((string)item.Header);
        }

        private void OnCenteredClick(object sender, RoutedEventArgs e)
        {
            this.Viewer.IsCentered = !this.Viewer.IsCentered;
        }

        #endregion

        #region Tools Menu

        private void OnUseMultiClick(object sender, RoutedEventArgs e)
        {
            MenuItem item = sender as MenuItem;
            if (item == null) return;

            _toolBehavior = (item.IsChecked ? MouseToolBehavior.MultiClick : MouseToolBehavior.ClickAndDrag);

            MagnifierMouseTool magtool = this.Viewer.MouseTool as MagnifierMouseTool;
            if (magtool != null)
            {
                magtool.ToolBehavior = _toolBehavior;
                return;
            }

            ZoomMouseTool zoomtool = this.Viewer.MouseTool as ZoomMouseTool;
            if (zoomtool != null)
            {
                if (_toolBehavior == MouseToolBehavior.MultiClick)
                    zoomtool.LeftButtonTool = ZoomToolMode.ZoomSelection;
                else
                    zoomtool.LeftButtonTool = ZoomToolMode.ZoomIn;

                zoomtool.ToolBehavior = _toolBehavior;
                return;
            }

            SelectionMouseTool seltool = this.Viewer.MouseTool as SelectionMouseTool;
            if (seltool != null) seltool.ToolBehavior = _toolBehavior;
        }

        private void OnMouseToolClick(object sender, RoutedEventArgs e)
        {
            MenuItem item = sender as MenuItem;
            if (item == null) return;

            this.MenuToolMagnifier.IsChecked = false;
            this.MenuToolNone.IsChecked = false;
            this.MenuToolPan.IsChecked = false;
            this.MenuToolSelection.IsChecked = false;
            this.MenuToolZoom.IsChecked = false;
            item.IsChecked = true;

            string header = (string)item.Header;
            switch (header)
            {
                case "None":
                    this.Viewer.MouseTool = null;
                    break;
                case "Magnifier":
                    this.Viewer.MouseTool = new MagnifierMouseTool(new Size(120, 120), _toolBehavior, 2, new Pen(new SolidColorBrush(Colors.Black), 1));
                    break;
                case "Pan":
                    this.Viewer.MouseTool = new PanningMouseTool();
                    break;
                case "Selection":
                    SelectionMouseTool sel = new SelectionMouseTool(new Rect(), _selectionType, _toolBehavior, null, Colors.Black, Colors.White, null, true, true, _selectionAspectRatio, _selectionAspectRatioMode, _animatedSelection, new Duration(TimeSpan.FromSeconds(3)), false, null);
                    sel.SelectionChanging += new EventHandler<SelectionMouseToolChangedEventArgs>(sel_SelectionChanging);
                    this.Viewer.MouseTool = sel;
                    break;
                case "Zoom":
                    ZoomMouseTool zoom = new ZoomMouseTool(0.2, _centerZoomClicks, _autoZoomSelection, MouseToolBehavior.ClickAndDrag, null, Colors.White, null, true);
                    if (_toolBehavior == MouseToolBehavior.MultiClick)
                        zoom.LeftButtonTool = ZoomToolMode.ZoomSelection;

                    this.Viewer.MouseTool = zoom;
                    break;
            }
        }

        #region Selection Tool Menus

        private void sel_SelectionChanging(object sender, SelectionMouseToolChangedEventArgs e)
        {
            this.statusInfo.Text = "Selection: " + e.Bounds.ToString();
        }

        private void OnSelectionAspectRationChanged(object sender, RoutedEventArgs e)
        {
            if (_selectionAspectRatio == 0)
                _selectionAspectRatio = 1;
            else
                _selectionAspectRatio = 0;
            
            SelectionMouseTool tool = this.Viewer.MouseTool as SelectionMouseTool;
            if (tool != null) tool.AspectRatio = _selectionAspectRatio;
            e.Handled = true;
        }

        private void OnSelectionTypeClicked(object sender, RoutedEventArgs e)
        {
            MenuItem item = sender as MenuItem;
            if (item == null) return;

            _selectionType = (SelectionMouseToolType)Enum.Parse(typeof(SelectionMouseToolType), (string)item.Header);

            SelectionMouseTool tool = this.Viewer.MouseTool as SelectionMouseTool;
            if (tool != null)
            {
                tool.Bounds = new Rect();
                tool.SelectionType = _selectionType;
            }
        }

        private void OnAspectRationModeClick(object sender, RoutedEventArgs e)
        {
            MenuItem item = sender as MenuItem;
            if (item == null) return;

            _selectionAspectRatioMode = (AspectRatioMode)Enum.Parse(typeof(AspectRatioMode), (string)item.Header);
            SelectionMouseTool tool = this.Viewer.MouseTool as SelectionMouseTool;
            if (tool != null) tool.AspectRatioCornerMode = _selectionAspectRatioMode;
            e.Handled = true;
        }

        private void OnAnimatedSelection(object sender, RoutedEventArgs e)
        {
            _animatedSelection = !_animatedSelection;

            SelectionMouseTool tool = this.Viewer.MouseTool as SelectionMouseTool;
            if (tool != null) tool.IsAnimated = _animatedSelection;
        }

        private void OnMaskedSelection(object sender, RoutedEventArgs e)
        {
            SelectionMouseTool tool = new SelectionMouseTool();
            tool.IsMasked = true;
            this.Viewer.MouseTool = tool;
        }

        #endregion

        #region Zoom Tool Menus

        private void OnCenterZoomClicks(object sender, RoutedEventArgs e)
        {
            _centerZoomClicks = !_centerZoomClicks;

            ZoomMouseTool tool = this.Viewer.MouseTool as ZoomMouseTool;
            if (tool != null) tool.CenterZoom = _centerZoomClicks;
        }

        private void OnAutoZoomSelection(object sender, RoutedEventArgs e)
        {
            _autoZoomSelection = !_autoZoomSelection;

            ZoomMouseTool tool = this.Viewer.MouseTool as ZoomMouseTool;
            if (tool != null) tool.AutoZoomSelection = _autoZoomSelection;
        }

        #endregion

        #endregion

        #region Processing Menu

        private void OnApplyInvert(object sender, RoutedEventArgs e)
        {
            ApplyCommand(new Atalasoft.Imaging.ImageProcessing.Channels.InvertCommand());
        }

        private void OnApplyCrop(object sender, RoutedEventArgs e)
        {
            SelectionMouseTool tool = this.Viewer.MouseTool as SelectionMouseTool;
            if (tool == null || tool.IsEmpty)
            {
                MessageBox.Show("Please use the selection tool to select the crop area.", "No Crop Selection");
                return;
            }

            Rect rc = tool.Bounds;
            ApplyCommand(new Atalasoft.Imaging.ImageProcessing.CropCommand(new System.Drawing.Rectangle((int)rc.X, (int)rc.Y, (int)rc.Width, (int)rc.Height)));
        }

        private void OnApplyMosaic(object sender, RoutedEventArgs e)
        {
            ApplyCommand(new Atalasoft.Imaging.ImageProcessing.Effects.MosaicCommand(10));
        }

        private void ApplyCommand(Atalasoft.Imaging.ImageProcessing.ImageCommand command)
        {
            try
            {
                if (command == null) return;
                
                // If the selection tool is in use and the command
                // supports region of interest, set it.
                Atalasoft.Imaging.ImageProcessing.ImageRegionCommand regCmd = command as Atalasoft.Imaging.ImageProcessing.ImageRegionCommand;
                if (regCmd != null) regCmd.RegionOfInterest = GetRegionOfInterest();

                this.Viewer.ApplyCommand(command);

                // In case there is a selection used, clear it.
                if (this.Viewer.MouseTool != null)
                    this.Viewer.MouseTool.Bounds = new Rect();
            }
            catch (Exception ex)
            {
                MessageBox.Show("There was an exception while processing a command.\r\n\r\n" + ex.Message, "Error");
            }
        }

        private Atalasoft.Imaging.ImageProcessing.RegionOfInterest GetRegionOfInterest()
        {
            SelectionMouseTool tool = this.Viewer.MouseTool as SelectionMouseTool;
            if (tool == null || tool.IsEmpty)
                return null;
            else
                return tool.GetRegion();
        }

        #endregion

        #region Demos

        private void ShowReflectionDemo(object sender, RoutedEventArgs e)
        {
            ReflectionWindow win = new ReflectionWindow();
            win.ShowDialog();
        }

        private void DoEllipseMagnifier(object sender, RoutedEventArgs e)
        {
            this.Viewer.MouseTool = new MagnifierMouseTool(new EllipseGeometry(new Rect(0, 0, 180, 90)), _toolBehavior, 2.0, new Pen(new SolidColorBrush(Colors.Black), 1));
        }

        private void DoFunkyMagnifier(object sender, RoutedEventArgs e)
        {
            PathGeometry geo = new PathGeometry();
            PathFigure fig = new PathFigure();
            fig.StartPoint = new Point(30, 120);
            fig.Segments.Add(new LineSegment(new Point(50, 120), true));
            fig.Segments.Add(new LineSegment(new Point(50, 80), true));
            fig.Segments.Add(new ArcSegment(new Point(30, 80), new Size(40, 40), 0, true, SweepDirection.Counterclockwise, true));
            fig.IsClosed = true;
            geo.Figures.Add(fig);

            this.Viewer.MouseTool = new MagnifierMouseTool(geo, _toolBehavior, 2.0, new Pen(new SolidColorBrush(Colors.Red), 1));
        }

        private void OnColorSelectionAnimation(object sender, RoutedEventArgs e)
        {
            SelectionMouseTool tool = new SelectionMouseTool();
            tool.IsAnimated = true;
            this.Viewer.MouseTool = tool;

            ColorAnimation ani = new ColorAnimation(Colors.Blue, Colors.Red, new Duration(TimeSpan.FromSeconds(2)));
            ani.RepeatBehavior = RepeatBehavior.Forever;
            ani.AutoReverse = true;

            tool.BeginAnimation(SelectionMouseTool.LineColorProperty, ani);
        }

        private void OnBlurSelection(object sender, RoutedEventArgs e)
        {
            this.Viewer.MouseTool = new SelectionMouseTool(SelectionMouseToolType.Ellipse, MouseToolBehavior.ClickAndDrag, true, new Atalasoft.Imaging.ImageProcessing.Filters.BlurGaussianCommand(3));
        }

        private void OnToggleSelection(object sender, RoutedEventArgs e)
        {
            SelectionMouseTool tool = this.Viewer.MouseTool as SelectionMouseTool;
            if (tool == null) return;

            if (tool.ToolBehavior == MouseToolBehavior.ClickAndDrag)
                tool.ToolBehavior = MouseToolBehavior.MultiClick;
            else
                tool.ToolBehavior = MouseToolBehavior.ClickAndDrag;
        }

        #endregion

        #region AtalaViewer Events
        private void OnImageChanged(object sender, ImageChangedEventArgs e)
        {
            this.statusInfo.Text = "ImageChanged Event";
            e.Handled = true;
        }

        private void OnViewerMouseMove(object sender, ImagePixelEventArgs e)
        {
            SelectionMouseTool tool = this.Viewer.MouseTool as SelectionMouseTool;
            if (tool == null || tool.Bounds.Width == 0)
                this.statusInfo.Text = "Pixel Position: " + e.Pixel.ToString();
            e.Handled = true;
        }
        #endregion

        private void HelpAbout_Click(object sender, RoutedEventArgs e)
        {
            // Instantiate the dialog box
            About dlg = new About("About Atalasoft WPF Demo", "WPF Demo");
            dlg.Description = "This is a somewhat simplified WPF version of our very popular DotImage Demo.\r\n\r\n" +
                              "The source code should provide a good working example of how yo use our AtalaImageViewer (the WPF version of our ImageViewer Winforms control) and perform various image processing commands in a WPF application.\r\n\r\n" +
                              "The AtalaImageViewer takes advantage of Atalasoft codecs to Open and Save images and image commands can be applied to the image using the ApplyCommand method. The viewer contains a Source property for a BitmapSource object, making its use in WPF straight forward.";
            dlg.Link = "www.atalasoft.com/KB/article.aspx?id=10412";

            // Configure the dialog box
            dlg.Owner = this;

            // Open the dialog box modally 
            dlg.ShowDialog();
        }

    }
}