// tells the WebImageViewer that it needs to update the image
function Invalidate(){
	WebImageViewer1.Update();
	WebThumbnailViewer1.Update();
}


// integer expected: 0:None 1:BestFit 2:BestFitShrinkOnly 3:FitToWidth 4:FitToHeight 5:FitToImage
function setAutoZoom(zoomMode){
	WebImageViewer1.setAutoZoom(zoomMode);
}

// Increments and decrements the zoom level by the given amount
function Zoom(inOut){
	var z = WebImageViewer1.getZoom();
	var zp = WebImageViewer1.getZoomInOutPercentage();
	
	z += inOut * z * zp / 100;
	
	WebImageViewer1.setZoom(z);
}


// Changes the mouse behavior
function ChangeMouseTool(i){
	switch(i){
		case 0:	// Pan tool
			WebImageViewer1.setMouseTool(6);
			WebImageViewer1.getSelection().Changed = function(){};
			break;
		case 1:	// Zoom tool
			WebImageViewer1.setMouseTool(3, 4);
			setAutoZoom(0);
			WebImageViewer1.getSelection().Changed = function(){};
			break;
		case 2:	// Zoom Area tool
			WebImageViewer1.setMouseTool(5);
			setAutoZoom(0);
			WebImageViewer1.getSelection().Changed = function(){};
			break;
		case 3:	// Crop tool
			WebImageViewer1.setMouseTool(2);
			WebImageViewer1.getSelection().Changed = function(){ Process_Region('Crop'); };
			WebImageViewer1.RemoteInvoked = Invalidate;
			break;
		case 4:	// Redaction tool
			WebImageViewer1.setMouseTool(2);
			WebImageViewer1.getSelection().Changed = function(){ WebImageViewer1.RemoteInvoke('Remote_DrawRedaction', new Array()); };
			WebImageViewer1.RemoteInvoked = Invalidate;
			break;
	}
}

// Uses RemoteInvoke to process a region specified by the selection rectangle
function Process_Region(cmd){
	WebImageViewer1.RemoteInvoke('Remote_ProcessRegion', new Array(cmd));
}

// Uses RemoteInvoke to process the entire image
function Process_Image(cmd){
	WebImageViewer1.RemoteInvoke('Remote_ProcessImage', new Array(cmd));
	WebImageViewer1.RemoteInvoked = Invalidate;
}



