using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Atalasoft.Imaging;
using Atalasoft.Imaging.Codec;
using Atalasoft.Imaging.Codec.Tiff;
using Atalasoft.Imaging.Drawing;
using Atalasoft.Imaging.ImageProcessing;
using Atalasoft.Imaging.ImageProcessing.Document;
using Atalasoft.Imaging.ImageProcessing.Transforms;
using Atalasoft.Imaging.WebControls;

namespace DotImageWebFormsDemo
{
	/// <summary>
	/// Summary description for WebFormsDemo_Thumbnail.
	/// </summary>
	public partial class WebFormsDemo_Thumbnail : System.Web.UI.Page
	{
	
		protected void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here
			if (! Page.IsPostBack) 
			{
                string orig = Page.MapPath("SampleImages/DocCleanMultipage.tif");
				string url = "AtalaCache/"+Page.Session.SessionID+"_tn.tif";
				string cached = Page.MapPath(url);

				// copy from Images to cache and make writable
				File.Copy(orig, cached, true);
				FileAttributes attr = File.GetAttributes(cached);
				attr &= ~FileAttributes.ReadOnly;
				File.SetAttributes(cached, attr);

				WebThumbnailViewer1.OpenUrl(url);
				WebImageViewer1.OpenUrl(url);
			}

		}

		#region Remote Invokes

		// Process the image, and use a selected region if it exists
		[RemoteInvokable]
		public void Remote_ProcessRegion(string commandName)
		{
			if (commandName.Equals("Crop"))
			{
				if (this.WebImageViewer1.Selection.Rectangle.Size != Size.Empty)
				{
					this.WebImageViewer1.Selection.Visibility = VisibilityStyle.Hidden;

					this.ApplyCommand(new CropCommand(this.WebImageViewer1.Selection.Rectangle));
				}
			}
			else
			{
				// Create a new command based on the user's selection
				ImageRegionCommand command = (ImageRegionCommand)GetCommand(commandName);

				// Check if there is a selection, and apply the selected area to the command if it exists
				if (this.WebImageViewer1.Selection.Rectangle.Size != Size.Empty)
					command.RegionOfInterest = new RegionOfInterest(this.WebImageViewer1.Selection.Rectangle);

				this.WebImageViewer1.ApplyCommand(command);
			}
		}

		// Process the entire image, ignoring the selection
		[RemoteInvokable]
		public void Remote_ProcessImage(string commandName)
		{
			// Create a new command based on the user's selection
			this.ApplyCommand(GetCommand(commandName));
		}

		// Draw a black box over the selected area
		[RemoteInvokable]
		public void Remote_DrawRedaction()
		{
			Canvas myCanvas = new Canvas(this.WebImageViewer1.Image);
			Rectangle selection = this.WebImageViewer1.Selection.Rectangle;

			myCanvas.DrawRectangle(selection, new AtalaPen(Color.Black), new SolidFill(Color.Black));

			this.WebImageViewer1.Selection.Visibility = VisibilityStyle.Hidden;

			SaveChanges(this.WebImageViewer1.Image);
		}

		#endregion

		#region Functions

		private void ApplyCommand(ImageCommand command)
		{
			if (command != null)
			{
				AtalaImage temp = WebImageViewer1.Image;

				if (command.InPlaceProcessing)
					command.Apply(temp);
				else
					temp = command.Apply(temp).Image;

				SaveChanges(temp);				
			}
		}

		private void SaveChanges(AtalaImage image)
		{
			string url = this.WebImageViewer1.ImageUrl;
			string path = Page.MapPath(url);
			int frame = this.WebImageViewer1.CurrentPage - 1;

			Stream fs = new FileStream(path, FileMode.Open, FileAccess.Read, FileShare.Read);

			TiffFile tFile = new TiffFile(); 
			tFile.Read(fs); 
			TiffDirectory tImage = new TiffDirectory(image, TiffCompression.Group4FaxEncoding); 
			tFile.Images.RemoveAt(frame);
			tFile.Images.Insert(frame, tImage); 
			tFile.Save(path + "_tmp");

			fs.Close();

			File.Delete(path); 
			File.Move(path + "_tmp", path);

			this.WebImageViewer1.OpenUrl(url, frame);
		}

		private ImageCommand GetCommand(string commandName)
		{
			ImageCommand command = null;

			switch(commandName)
			{
				case "Crop":
					command = new CropCommand();
					break;
				case "Deskew":
					command = new AutoDeskewCommand();
					break;
				case "Despeckle":
					command = new DocumentDespeckleCommand();
					break;
				case "RemoveNoise":
					command = new DocumentMedianCommand();
					break;
				case "RotateRight":
					command = new RotateCommand(90.0);
					break;
				case "RotateLeft":
					command = new RotateCommand(-90.0);
					break;
				case "FlipHorizontal":
					command = new FlipCommand(FlipDirection.Horizontal);
					break;
				case "FlipVertical":
					command = new FlipCommand(FlipDirection.Vertical);
					break;
			}

			return command;
		}

		#endregion
	}
}
