using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Atalasoft.Imaging;
using Atalasoft.Imaging.Codec;
using Atalasoft.Imaging.ImageProcessing;
using Atalasoft.Imaging.ImageProcessing.Filters;
using Atalasoft.Imaging.ImageProcessing.Effects;
using Atalasoft.Imaging.ImageProcessing.Channels;
using Atalasoft.Imaging.ImageProcessing.Transforms;
using Atalasoft.Imaging.Drawing;

namespace DotImageWebFormsDemo
{
	public partial class WebFormsDemo_Image : System.Web.UI.Page
	{
		protected void Page_Load(object sender, System.EventArgs e)
		{
			Workspace myWorkspace = new Workspace();

			//open image
			string url = Request.QueryString["url"];
			if (url != null)
				url = url.ToLower();
			else
				url = "SampleImages/goldengate.jpg";
		
			if (url.StartsWith("http://") || url.StartsWith("https://") || url.StartsWith("ftp://"))
				myWorkspace.Open(url);
			else
				myWorkspace.Open(Server.MapPath(".") + "\\" + url);

			//process effect
			string effect = Request.QueryString["effect"];
			if (effect != null)
			{
				switch (effect.ToLower())
				{
					case "drop shadow":
						myWorkspace.ApplyCommand(new DropShadowCommand(10));
						myWorkspace.ApplyCommand(new FlattenAlphaCommand(Color.White));
						break;
					case "emboss":
						myWorkspace.ApplyCommand(new EmbossCommand(135, 135, 10));
						break;
					case "intensify":
						myWorkspace.ApplyCommand(new IntensifyCommand(50));
						break;
					case "unsharp mask":
						myWorkspace.ApplyCommand(new UnsharpMaskCommand(0, 1, 2.4));
						break;
					case "text":
						Canvas myCanvas = new Canvas(myWorkspace.Image);
						myCanvas.DrawText("Imaging in .NET with Atalasoft dotImage", new Rectangle(Point.Empty, myWorkspace.Image.Size), new Font("Veranda", 14), new SolidFill(Color.FromArgb(127, Color.Black)));
						break;
					case "mosaic":
						myWorkspace.ApplyCommand(new MosaicCommand(15));
						break;
					case "marble":
						myWorkspace.ApplyCommand(new MarbleTransform(0.8, new Size(5, 5)));
						break;
					case "random":
						myWorkspace.ApplyCommand(new RandomTransform(20));
						break;
					case "skew":
						myWorkspace.ApplyCommand(new SkewCommand(SkewDirection.Horizontal, 60, Color.White, false));
						break;
					case "thumbnail":
						myWorkspace.ApplyCommand(new ResampleCommand(200, ResampleMethod.LanczosFilter));
						break;

				}
			}

			//display a progressive JPEG image
			Response.ContentType = "image/jpeg";
			myWorkspace.Save(Response.OutputStream, new JpegEncoder(75, 0, true));
		}
	}
}
