﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="WebDocumentViewerAnnotations.aspx.cs" Inherits="WebDocumentViewerAnnotations" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>WebDocumentViewer Annotations Demo</title>
    <script src="WebDocViewer/jquery-1.11.0.min.js" type="text/javascript"></script>
    <script src="WebDocViewer/jquery-ui-1.10.4.min.js" type="text/javascript"></script>
    <script src="WebDocViewer/jquery.easing.1.3.js" type="text/javascript"></script>
    <script src="WebDocViewer/clipboard.min.js" type="text/javascript"></script>
    <script src="WebDocViewer/raphael-min.js" type="text/javascript"></script>
	<script src="WebDocViewer/atalaWebDocumentViewer.js" type="text/javascript"></script>

	<link href="WebDocViewer/jquery-ui-1.10.4.min.css" rel="Stylesheet" type="text/css" />
    <link href="WebDocViewer/atalaWebDocumentViewer.css" rel="Stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <div id="_toolbar1" class="atala-document-toolbar" style="width: 670px;"></div>
        <div id="_container1" class="atala-document-container" style="width: 670px; height: 500px;"></div>
        <div id="_status" style="width: 670px; height: 20px; border: 1px solid silver; margin-top: 3px;"></div>
    </div>
    </form>

    <script type="text/javascript" language="javascript">
        var _hasPDF = <%= HasPDF %>;
        var _docUrl = (_hasPDF) ? 'SampleImages/multipage.pdf' : 'SampleImages/GearDocument.tif';
        var _serverUrl = 'WebDocViewerHandler.ashx';
        var _saveFolder = 'SaveFolder/';

        var _viewer = new Atalasoft.Controls.WebDocumentViewer({
            'parent': $('#_container1'),        // parent container to put the viewer in
            'toolbarparent': $('#_toolbar1'),   // parent container to put the viewer toolbar in
            'serverurl': _serverUrl,            // server handler url to send image requests to
            'savepath': _saveFolder,			// relative server path where annotations can be saved to
            'allowannotations': true,			// enables the annotation toolbar and capability
            'showerrors': true,					// allows uncaught JS exceptions to show in the console, (used for debugging)
            'documenturl': _docUrl		        // document url relative to the server handler url
        });
        
        // bind event handlers
        _viewer.bind({
			'error': onError,
			'documentsaved': onDocumentSaved
		});

		// triggered when an exception is thrown and caught by the viewer
		function onError(e){
			setStatus('Error: ' + e.name + '\n' + e.message);
		}

		// triggered after a response has been recieved from the server, after the save button has been clicked
		function onDocumentSaved(e){
			var msg = (e.success) ? 'Document save successful.' : 'Document save failed.';
			setStatus(msg);

			setTimeout(function(){ setStatus(''); }, 30000);
		}

		// writes a status message to the status div
		function setStatus(s){
			$('#_status').text(s);
		}

        // --- Default Annotation Properties ---
        // If multiple objects with the same type are defined below, only the last one of each type will be used.
        _viewer.setAnnotationDefaults([
			{ type: 'ellipse',
				fill: {
					color: 'white',
					opacity: 0.0
				},
				outline: {
					width: 5
				}
			},
			{ type: 'freehand',
				outline: {
					color: 'green',
					width: 10
				}
			},
			{ type: 'text',
				fill: {
					color: 'red',
					opacity: 0.5
				},
				outline: {
					color: 'black',
					width: 4
				},
				text: {
					value: 'Double-click to edit',
					font: {
						bold: true,
						family: 'Trebuchet MS',
						size: 48
					}
				}
			}
        ]);

        // --- Stamp Annotation Properties ---
        // If setStamps is not called, the button to create Stamp annotations will not appear
        _viewer.setStamps([
			{ type: 'stamp',
				name: 'Approved',
				fill: {
					color: '#E7C56B',
					opacity: 0.5
				},
				outline: {
					color: '#43BC6F'
				},
				width: 55,
				height: 188,
				text: {
					value: 'APPROVED',
					align: 'left',
					font: {
						bold: true,
						color: '#43BC6F',
						family: 'Georgia',
						size: 32
					}
				}
			},
			{ type: 'stamp',
				name: 'Rejected',
				fill: {
					color: '#F1DCEC',
					opacity: 0.75
				},
				outline: {
					color: '#000000'
				},
				text: {
					value: 'REJECTED',
					align: 'left',
					font: {
						bold: true,
						color: '#FC6173',
						family: 'Georgia',
						size: 24
					}
				}
			}
		]);

        // --- Image Annotation Properties
        // If setImages is not called, the button to create Image annotations will not appear
        _viewer.setImages([
            { type: 'image',
            	name: 'Alpha Atala',
            	src: 'SampleImages/alpha_atala.png'
            },
            { type: 'image',
            	name: 'Draft',
            	src: 'SampleImages/draft.png'
            }
		]);
	</script>
</body>
</html>

