using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Atalasoft.Imaging;
using Atalasoft.Imaging.Codec;
using Atalasoft.Imaging.WebControls;
using Atalasoft.Imaging.ImageProcessing;
using Atalasoft.Imaging.ImageProcessing.Effects;
using Atalasoft.Imaging.ImageProcessing.Filters;
using Atalasoft.Imaging.ImageProcessing.Transforms;

namespace DotImageWebFormsDemo
{
	public partial class WebControlsSimpleDemo : System.Web.UI.Page
	{
	
		protected void Page_Load(object sender, System.EventArgs e)
		{
			// Sets the default image upon initial page load.
			if (!Page.IsPostBack)
				WebImageViewer1.OpenUrl("SampleImages/Chaotic_Light_3D.jpg");
		}

		protected void Button1_Click(object sender, System.EventArgs e)
		{
			// Loads the file from the browser's input stream, if it exists.
			if (File1.PostedFile.FileName.Length != 0)
				WebImageViewer1.Open(File1.PostedFile.InputStream);
			else
				Label1.Text = "Error: You must specify a file name.";
		}

		#region Remote Invokes

		[RemoteInvokable]
		public void CropSelection()
		{
			// Make sure the selection is > 0
			if (!WebImageViewer1.Selection.Rectangle.Size.IsEmpty)
			{
				// Crops the image to the selection
				WebImageViewer1.ApplyCommand(new CropCommand(WebImageViewer1.Selection.Rectangle));

				// Resets the RubberBand
				WebImageViewer1.Selection.Reset();
			}
		}

		[RemoteInvokable]
		public void EmbossSelection()
		{
			// Creates a new Emboss command
			EmbossCommand myEmboss = new EmbossCommand(45,10,10);

			// Specifies a region to emboss if the selection is not empty
			if (!WebImageViewer1.Selection.Rectangle.Size.IsEmpty){
				myEmboss.RegionOfInterest = new RegionOfInterest(WebImageViewer1.Selection.Rectangle);
			}

			// Embosses the image
			WebImageViewer1.ApplyCommand(myEmboss);
		}

		#endregion
	}
}
