using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace DotImageWebFormsDemo
{
	/// <summary>
	/// Summary description for WebControlsMultiDemo_ImageUploader.
	/// </summary>
	public partial class WebControlsMultiDemo_ImageUploader : System.Web.UI.Page
	{
	
		protected void Page_Load(object sender, System.EventArgs e)
		{
		}

		protected void Button1_ServerClick(object sender, System.EventArgs e)
		{
			if (File1.PostedFile.FileName.Length != 0) 
			{	// Get the relative server path to the Cache
				string pathToCache = System.Configuration.ConfigurationSettings.AppSettings["AtalasoftWebControls_Cache"];
	
				// We prefix the file name with the Page.Session.SessionID so
				// that the CacheManager will delete it when the session expires
				string fileName = Page.Session.SessionID + "_" + System.IO.Path.GetFileName(File1.PostedFile.FileName);
                string jscript = string.Empty;

				try
				{	// Save uploaded file to server cache.
					File1.PostedFile.SaveAs(Page.MapPath(pathToCache) + fileName);
                    jscript = "	window.parent.onDropDown_ImageChanged('" + pathToCache + fileName + "');\n";

				}
				catch (Exception) 
				{	// Sends errors to a label
                    jscript = "	window.parent.onError('An error occured while attempting to cache the uploaded image.');\n";
                }

				// Load the image in the WebImageViewer
				this.Page.RegisterStartupScript("UploadImage_Script", "<script language=\"javascript\">\n<!--\n" +
                    jscript +
					"// -->" + "\n</script>\n");
			}

		}
	}
}
