using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using Atalasoft.Imaging;
using Atalasoft.Imaging.Codec;
using Atalasoft.Imaging.Drawing;
using Atalasoft.Imaging.WebControls;
using Atalasoft.Imaging.ImageProcessing;
using Atalasoft.Imaging.ImageProcessing.Channels;
using Atalasoft.Imaging.ImageProcessing.Transforms;
using Atalasoft.Imaging.ImageProcessing.Effects;
using Atalasoft.Imaging.ImageProcessing.Filters;

namespace DotImageWebFormsDemo
{
	public partial class dotImageWebControlsDemo : System.Web.UI.Page
	{
		protected void Page_Load(object sender, System.EventArgs e)
		{
			// Location of the image files (not resources)
			string pathPrefix = "SampleImages/";

			// If this page is a new one, pre-load an image from the resources folder
			if(!this.IsPostBack)
			{
				this.WebImageViewerMain.OpenUrl(pathPrefix + "Rosebud.jpg");
				this.WebImageViewerPreview.OpenUrl(pathPrefix + "Rosebud.jpg");
			}
		}

		#region Remote Invokes

		// Process the image, and use a selected region if it exists
		[RemoteInvokable]
		public string Process_Region(string selectedValue)
		{
			try
			{
				if (selectedValue.Equals("Crop"))
				{
					if (this.WebImageViewerMain.Selection.Rectangle.Size != Size.Empty)
					{
						WebImageViewerMain.ApplyCommand(new CropCommand(this.WebImageViewerMain.Selection.Rectangle));
						this.WebImageViewerMain.Selection.Reset();
					}
				}
				else
				{
					// Create a new command based on the user's selection
					ImageRegionCommand command = (ImageRegionCommand)GetCommand(selectedValue);

					// Check if there is a selection, and apply the selected area to the command if it exists
					if (this.WebImageViewerMain.Selection.Rectangle.Size != Size.Empty)
						command.RegionOfInterest = new RegionOfInterest(this.WebImageViewerMain.Selection.Rectangle);

					WebImageViewerMain.ApplyCommand(command);
				}
			}			
			catch (Exception)
			{	// Update status if error occurs
                return "Error occured while attempting to apply an image command to specified region.";
			}

            return string.Empty;
		}

		// Process the entire image, ignoring the selection
		[RemoteInvokable]
		public string Process_Image(string selectedValue)
		{
			// Create a new command based on the user's selection
			ImageCommand command = GetCommand(selectedValue);

			try
			{	// Apply the command
				WebImageViewerMain.ApplyCommand(command);
				// Flatten the Alpha channel if one was created so we can see it in the browser
				if (AtalaImage.PixelFormatHasAlpha(WebImageViewerMain.Image.PixelFormat) == true)
					WebImageViewerMain.ApplyCommand(new FlattenAlphaCommand(Color.White));
			}
			catch (Exception)
			{	// Update status if error occurs
                return "Error occured while attempting to apply an image command.";
			}

            return string.Empty;
		}

		// Process the color depth change
		[RemoteInvokable]
		public string Process_Color(string selectedValue)
		{
			ImageCommand command;
			
			// Create a command based on the user selection
			switch(selectedValue)
			{
				case "RGB":
				default:			// 24bit color
					command = new ChangePixelFormatCommand(PixelFormat.Pixel24bppBgr);
					break;
				case "Paletted":	// Indexed pallete
					command = new ChangePixelFormatCommand(PixelFormat.Pixel8bppIndexed);
					break;
				case "Greyscale":	// Grayscale
					command = new ChangePixelFormatCommand(PixelFormat.Pixel8bppGrayscale);
					break;
				case "BW":			// Black and white
					command = new ApplyPaletteCommand(new Palette(Color.Black, Color.White), DitheringMode.FloydSteinberg);
					break;
			}

			try
			{	// Apply the command
				WebImageViewerMain.ApplyCommand(command);
			}
			catch (Exception)
			{	// Update status if error occurs
                return "Error occured while attempting to change pixel format.";
			}

            return string.Empty;
		}

		[RemoteInvokable]
		public void Draw_Selection(string selectedValue, bool fill, bool alpha)
		{
			Canvas myCanvas = new Canvas(this.WebImageViewerMain.Image);
			Rectangle mySelection = this.WebImageViewerMain.Selection.Rectangle;

			switch (selectedValue)
			{
				case "rectangle":
					if (fill)
					{
						if (alpha)
							myCanvas.DrawRectangle(mySelection, new AtalaPen(Color.Black), new SolidFill(Color.FromArgb(128, Color.DarkOrange)));
						else
							myCanvas.DrawRectangle(mySelection, new AtalaPen(Color.Black), new SolidFill(Color.Orange));
					}
					else
					{
						if (alpha)
							myCanvas.DrawRectangle(mySelection, new AtalaPen(Color.FromArgb(128, Color.Black)));
						else
							myCanvas.DrawRectangle(mySelection, new AtalaPen(Color.Black));
					}

					this.WebImageViewerMain.Selection.Reset();
					break;

				case "circle":
					if (fill)
					{
						if (alpha)
							myCanvas.DrawEllipse(mySelection, new AtalaPen(Color.Black), new SolidFill(Color.FromArgb(128, Color.DarkOrange)));
						else
							myCanvas.DrawEllipse(mySelection, new AtalaPen(Color.Black), new SolidFill(Color.Orange));
					}
					else
					{
						if (alpha)
							myCanvas.DrawEllipse(mySelection, new AtalaPen(Color.FromArgb(128, Color.Black)));
						else
							myCanvas.DrawEllipse(mySelection, new AtalaPen(Color.Black));
					}

					this.WebImageViewerMain.Selection.Reset();
					break;

				case "text":
					Font myFont = new Font(this.WebImageViewerMain.Font.Name, 30);

					if (fill)
					{
						if (alpha)
							myCanvas.DrawText("Atalasoft", mySelection, myFont, new SolidFill(Color.Black), new SolidFill(Color.FromArgb(128, Color.DarkOrange)), new TextFormat(TextAlignment.Left));
						else
							myCanvas.DrawText("Atalasoft", mySelection, myFont, new SolidFill(Color.Black), new SolidFill(Color.Orange), new TextFormat(TextAlignment.Left));
					}
					else
					{
						if (alpha)
							myCanvas.DrawText("Atalasoft", mySelection, myFont, new SolidFill(Color.FromArgb(128, Color.Black)));
						else
							myCanvas.DrawText("Atalasoft", mySelection, myFont, new SolidFill(Color.Black));
					}

					this.WebImageViewerMain.Selection.Reset();
					break;

				case "image":
					Workspace workspace = new Workspace();

					workspace.Image = new AtalaImage(Page.MapPath("Images/") + "alpha_atala.png") ;
					workspace.ApplyCommand(new ResampleCommand(mySelection.Size, ResampleMethod.LanczosFilter));

					if (fill)
					{
						if (alpha)
							myCanvas.DrawRectangle(mySelection, new AtalaPen(Color.Black), new SolidFill(Color.FromArgb(128, Color.DarkOrange)));
						else
							myCanvas.DrawRectangle(mySelection, new AtalaPen(Color.Black), new SolidFill(Color.Orange));
					}
					else
					{
						if (!alpha)
							myCanvas.DrawRectangle(mySelection, new AtalaPen(Color.Black), new SolidFill(Color.White));
					}

					this.WebImageViewerMain.ApplyCommand(new OverlayCommand(workspace.Image, mySelection.Location));
					

					this.WebImageViewerMain.Selection.Reset();

					break;
			}

			this.WebImageViewerMain.Update();
		}

		#endregion

		#region Functions

		private ImageCommand GetCommand(string commandName)
		{
			ImageCommand command;

			switch(commandName)
			{
				case "Crop":
					command = new CropCommand();
					break;
				case "Blur":
				default:
					command = new BlurGaussianCommand(3);
					break;
				case "DropShadow":
					command = new DropShadowCommand(10);
					break;
				case "Emboss":
					command = new EmbossCommand(135, 10, 10, false);
					break;
				case "Threshold":
					command = new ThresholdCommand(24, 80);
					break;
				case "UnsharpMask":
					command = new UnsharpMaskCommand(0, 1, 2.4);
					break;
				case "Mosaic":
					command = new MosaicCommand(6);
					break;
				case "Rotate90":
					command = new RotateCommand(90.0);
					break;
				case "Rotate-90":
					command = new RotateCommand(-90.0);
					break;
				case "FlipHorizontal":
					command = new FlipCommand(FlipDirection.Horizontal);
					break;
				case "FlipVertical":
					command = new FlipCommand(FlipDirection.Vertical);
					break;

			}

			return command;
		}

		#endregion
	}
}
