Imports Microsoft.VisualBasic
Imports System
Imports System.Collections
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.IO
Imports System.Web
Imports System.Web.SessionState
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports System.Web.UI.HtmlControls
Imports Atalasoft.Imaging
Imports Atalasoft.Imaging.Codec
Imports Atalasoft.Imaging.Codec.Tiff
Imports Atalasoft.Imaging.Drawing
Imports Atalasoft.Imaging.ImageProcessing
Imports Atalasoft.Imaging.ImageProcessing.Document
Imports Atalasoft.Imaging.ImageProcessing.Transforms
Imports Atalasoft.Imaging.WebControls

Namespace DotImageWebFormsDemo
	Partial Class WebFormsDemo_Thumbnail : Inherits System.Web.UI.Page

		Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
			' Put user code to initialize the page here
			If (Not Page.IsPostBack) Then
				Dim orig As String = Page.MapPath("SampleImages/DocCleanMultipage.tif")
				Dim url As String = "AtalaCache" & Page.Session.SessionID & "_tn.tif"
				Dim cached As String = Page.MapPath(url)

				' copy from Images to cache and make writable
				File.Copy(orig, cached, True)
				Dim attr As FileAttributes = File.GetAttributes(cached)
				attr = attr And Not FileAttributes.ReadOnly
				File.SetAttributes(cached, attr)

				WebThumbnailViewer1.OpenUrl(url)
				WebImageViewer1.OpenUrl(url)
			End If

		End Sub

#Region "Remote Invokes"

		' Process the image, and use a selected region if it exists
		<RemoteInvokable()> _
		Public Sub Remote_ProcessRegion(ByVal commandName As String)
			If commandName.Equals("Crop") Then
				If Me.WebImageViewer1.Selection.Rectangle.Size <> Size.Empty Then
					Me.WebImageViewer1.Selection.Visibility = VisibilityStyle.Hidden

					Me.ApplyCommand(New CropCommand(Me.WebImageViewer1.Selection.Rectangle))
				End If
			Else
				' Create a new command based on the user's selection
				Dim command As ImageRegionCommand = CType(GetCommand(commandName), ImageRegionCommand)

				' Check if there is a selection, and apply the selected area to the command if it exists
				If Me.WebImageViewer1.Selection.Rectangle.Size <> Size.Empty Then
					command.RegionOfInterest = New RegionOfInterest(Me.WebImageViewer1.Selection.Rectangle)
				End If

				Me.WebImageViewer1.ApplyCommand(command)
			End If
		End Sub

		' Process the entire image, ignoring the selection
		<RemoteInvokable()> _
		Public Sub Remote_ProcessImage(ByVal commandName As String)
			' Create a new command based on the user's selection
			Me.ApplyCommand(GetCommand(commandName))
		End Sub

		' Draw a black box over the selected area
		<RemoteInvokable()> _
		Public Sub Remote_DrawRedaction()
			Dim myCanvas As Canvas = New Canvas(Me.WebImageViewer1.Image)
			Dim selection As Rectangle = Me.WebImageViewer1.Selection.Rectangle

			myCanvas.DrawRectangle(selection, New AtalaPen(Color.Black), New SolidFill(Color.Black))

			Me.WebImageViewer1.Selection.Visibility = VisibilityStyle.Hidden

			SaveChanges(Me.WebImageViewer1.Image)
		End Sub

#End Region

#Region "Functions"

		Private Sub ApplyCommand(ByVal command As ImageCommand)
			If Not command Is Nothing Then
				Dim temp As AtalaImage = WebImageViewer1.Image

				If command.InPlaceProcessing Then
					command.Apply(temp)
				Else
					temp = command.Apply(temp).Image
				End If

				SaveChanges(temp)
			End If
		End Sub

		Private Sub SaveChanges(ByVal image As AtalaImage)
			Dim url As String = Me.WebImageViewer1.ImageUrl
			Dim path As String = Page.MapPath(url)
			Dim frame As Integer = Me.WebImageViewer1.CurrentPage - 1

			Dim fs As Stream = New FileStream(path, FileMode.Open, FileAccess.Read, FileShare.Read)

			Dim tFile As TiffFile = New TiffFile()
			tFile.Read(fs)
			Dim tImage As TiffDirectory = New TiffDirectory(image, TiffCompression.Group4FaxEncoding)
			tFile.Images.RemoveAt(frame)
			tFile.Images.Insert(frame, tImage)
			tFile.Save(path & "_tmp")

			fs.Close()

			File.Delete(path)
			File.Move(path & "_tmp", path)

			Me.WebImageViewer1.OpenUrl(url, frame)
		End Sub

		Private Function GetCommand(ByVal commandName As String) As ImageCommand
			Dim command As ImageCommand = Nothing

			Select Case commandName
				Case "Crop"
					command = New CropCommand()
				Case "Deskew"
					command = New AutoDeskewCommand()
				Case "Despeckle"
					command = New DocumentDespeckleCommand()
				Case "RemoveNoise"
					command = New DocumentMedianCommand()
				Case "RotateRight"
					command = New RotateCommand(90.0)
				Case "RotateLeft"
					command = New RotateCommand(-90.0)
				Case "FlipHorizontal"
					command = New FlipCommand(FlipDirection.Horizontal)
				Case "FlipVertical"
					command = New FlipCommand(FlipDirection.Vertical)
			End Select

			Return command
		End Function

#End Region

	End Class
End Namespace
