Imports Microsoft.VisualBasic
Imports System
Imports System.Collections
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Web
Imports System.Web.SessionState
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports System.Web.UI.HtmlControls
Imports Atalasoft.Imaging
Imports Atalasoft.Imaging.Codec
Imports Atalasoft.Imaging.ImageProcessing
Imports Atalasoft.Imaging.ImageProcessing.Filters
Imports Atalasoft.Imaging.ImageProcessing.Effects
Imports Atalasoft.Imaging.ImageProcessing.Channels
Imports Atalasoft.Imaging.ImageProcessing.Transforms
Imports Atalasoft.Imaging.Drawing

Namespace DotImageWebFormsDemo
	Partial Class WebFormsDemo_Image : Inherits System.Web.UI.Page
		Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
			Dim myWorkspace As Workspace = New Workspace()

			'open image
			Dim url As String = Request.QueryString("url")
			If Not url Is Nothing Then
				url = url.ToLower()
			Else
				url = "SampleImages/goldengate.jpg"
			End If

			If url.StartsWith("http://") OrElse url.StartsWith("https://") OrElse url.StartsWith("ftp://") Then
				myWorkspace.Open(url)
			Else
				myWorkspace.Open(Server.MapPath(".") & "\" & url)
			End If

			'process effect
			Dim effect As String = Request.QueryString("effect")
			If Not effect Is Nothing Then
				Select Case effect.ToLower()
					Case "drop shadow"
						myWorkspace.ApplyCommand(New DropShadowCommand(10))
						myWorkspace.ApplyCommand(New FlattenAlphaCommand(Color.White))
					Case "emboss"
						myWorkspace.ApplyCommand(New EmbossCommand(135, 135, 10))
					Case "intensify"
						myWorkspace.ApplyCommand(New IntensifyCommand(50))
					Case "unsharp mask"
						myWorkspace.ApplyCommand(New UnsharpMaskCommand(0, 1, 2.4))
					Case "text"
						Dim myCanvas As Canvas = New Canvas(myWorkspace.Image)
						myCanvas.DrawText("Imaging in .NET with Atalasoft dotImage", New Rectangle(Point.Empty, myWorkspace.Image.Size), New Font("Veranda", 14), New SolidFill(Color.FromArgb(127, Color.Black)))
					Case "mosaic"
						myWorkspace.ApplyCommand(New MosaicCommand(15))
					Case "marble"
						myWorkspace.ApplyCommand(New MarbleTransform(0.8, New Size(5, 5)))
					Case "random"
						myWorkspace.ApplyCommand(New RandomTransform(20))
					Case "skew"
						myWorkspace.ApplyCommand(New SkewCommand(SkewDirection.Horizontal, 60, Color.White, False))
					Case "thumbnail"
						myWorkspace.ApplyCommand(New ResampleCommand(200, ResampleMethod.LanczosFilter))

				End Select
			End If

			'display a progressive JPEG image
			Response.ContentType = "image/jpeg"
			myWorkspace.Save(Response.OutputStream, New JpegEncoder(75, 0, True))
		End Sub

	End Class
End Namespace
