Imports Microsoft.VisualBasic
Imports System
Imports System.IO
Imports System.Collections
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Web
Imports System.Web.SessionState
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports System.Web.UI.HtmlControls

Imports System.Runtime.Serialization
Imports System.Reflection

Imports Atalasoft.Imaging
Imports Atalasoft.Imaging.Codec
Imports Atalasoft.Imaging.Codec.Tiff
Imports Atalasoft.Imaging.ImageProcessing
Imports Atalasoft.Imaging.WebControls
Imports Atalasoft.Annotate
Imports Atalasoft.Annotate.UI


Namespace DotImageWebFormsDemo
	Partial Class WebFormsDemoAnnotations : Inherits System.Web.UI.Page
		Protected Shared _hasPDF As Boolean

		Shared Sub New()
			Try
				Atalasoft.Imaging.Codec.RegisteredDecoders.Decoders.Add(New Atalasoft.Imaging.Codec.Pdf.PdfDecoder)
				_hasPDF = True
			Catch e As System.Exception
				_hasPDF = False
			End Try
		End Sub

		Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
			' Sets up the default annotation collection
			InitializeDefaultAnnotations()

			' Put user code to initialize the page here
			If (Not Page.IsPostBack) Then
				OpenFile("DocCleanMultipage.tif")
			End If
		End Sub

#Region "Remote Invokes"

		<RemoteInvokable()> _
		Public Function OpenFile(ByVal file As String) As String
			Dim orig As String = Page.MapPath("SampleImages/" & File)
			Dim url As String = "AtalaCache" & Page.Session.SessionID & "_tn.tif"
			Dim cached As String = Page.MapPath(url)

			If (file.EndsWith("pdf") And Not _hasPDF) Then
				Return ""
			End If

			' copy from Images to cache and make writable
			System.IO.File.Copy(orig, cached, True)
			Dim attr As FileAttributes = System.IO.File.GetAttributes(cached)
			attr = attr And Not FileAttributes.ReadOnly
			System.IO.File.SetAttributes(cached, attr)

			WebThumbnailViewer1.OpenUrl(url)
			WebAnnotationViewer1.OpenUrl(url)

			Return url
		End Function

		<RemoteInvokable()> _
		Public Sub Remote_ProcessImage(ByVal commandName As String)
			' Create a new command based on the user's selection
			Me.ApplyCommand(GetCommand(commandName))
		End Sub

		' called by the client when Properties... is chosen from the context menu
		<RemoteInvokable()> _
		Public Function PopupAnnoDialog(ByVal layerIndex As Integer, ByVal index As Integer) As String
			Dim anno As AnnotationUI = WebAnnotationViewer1.Annotations.GetAnnotation(layerIndex, -1, index)
			Dim d As AnnotationData = anno.Data

			Dim outlineColor As String = ""
			Dim outlineWidth As Integer = 0
			Dim fillColor As String = ""

			Dim e As EllipseData = CType(IIf(TypeOf d Is EllipseData, d, Nothing), EllipseData)
			Dim r As RectangleData = CType(IIf(TypeOf d Is RectangleData, d, Nothing), RectangleData)
			Dim t As TextData = CType(IIf(TypeOf d Is TextData, d, Nothing), TextData)

			If Not e Is Nothing Then
				outlineColor = FormatColor(e.Outline.Color)
				outlineWidth = CInt(e.Outline.Width)
				fillColor = FormatColor(e.Fill.Color)
			ElseIf Not t Is Nothing Then
				outlineColor = FormatColor(t.Outline.Color)
				outlineWidth = CInt(t.Outline.Width)
				fillColor = FormatColor(t.Fill.Color)
			ElseIf Not r Is Nothing Then
				outlineColor = FormatColor(r.Outline.Color)
				outlineWidth = CInt(r.Outline.Width)
				fillColor = FormatColor(r.Fill.Color)
			End If

			Return outlineColor & ":" & outlineWidth & ":" & fillColor
		End Function

		' called by the client when the Properties... is saved
		<RemoteInvokable()> _
		Public Function SaveProps(ByVal layerIndex As Integer, ByVal index As Integer, ByVal outlineColor As String, ByVal outlineWidth As String, ByVal fillColor As String) As String
			Try
				Dim anno As AnnotationUI = WebAnnotationViewer1.Annotations.GetAnnotation(layerIndex, -1, index)
				Dim d As AnnotationData = anno.Data

				Dim e As EllipseData = CType(IIf(TypeOf d Is EllipseData, d, Nothing), EllipseData)
				Dim r As RectangleData = CType(IIf(TypeOf d Is RectangleData, d, Nothing), RectangleData)
				Dim t As TextData = CType(IIf(TypeOf d Is TextData, d, Nothing), TextData)

				If Not e Is Nothing Then
					e.Outline.Color = ParseColor(outlineColor)
					e.Outline.Width = ParseInt(outlineWidth)
					e.Fill.Color = ParseColor(fillColor)
				ElseIf Not r Is Nothing Then
					r.Outline.Color = ParseColor(outlineColor)
					r.Outline.Width = ParseInt(outlineWidth)
					r.Fill.Color = ParseColor(fillColor)
				ElseIf Not t Is Nothing Then
					t.Outline.Color = ParseColor(outlineColor)
					t.Outline.Width = ParseInt(outlineWidth)
					t.Fill.Color = ParseColor(fillColor)
				End If
				WebAnnotationViewer1.UpdateAnnotations()
			Catch e As System.Exception
				Return e.Message
			End Try
			Return ""
		End Function

#End Region

#Region "Functions"

		Private Sub ApplyCommand(ByVal command As ImageCommand)
			If Not command Is Nothing Then
				Dim temp As AtalaImage = WebAnnotationViewer1.Image

				If command.InPlaceProcessing Then
					command.Apply(temp)
				Else
					temp = command.Apply(temp).Image
				End If

				SaveChanges(temp)
			End If
		End Sub

		Private Sub SaveChanges(ByVal image As AtalaImage)
			Dim url As String = Me.WebAnnotationViewer1.ImageUrl
			Dim path As String = Page.MapPath(url)
			Dim frame As Integer = Me.WebAnnotationViewer1.CurrentPage - 1

			Dim fs As Stream = New FileStream(path, FileMode.Open, FileAccess.Read, FileShare.Read)

			Dim tFile As TiffFile = New TiffFile()
			tFile.Read(fs)
			Dim tImage As TiffDirectory = New TiffDirectory(image, TiffCompression.Group4FaxEncoding)
			tFile.Images.RemoveAt(frame)
			tFile.Images.Insert(frame, tImage)
			tFile.Save(path & "_tmp")

			fs.Close()

			File.Delete(path)
			File.Move(path & "_tmp", path)

			Me.WebAnnotationViewer1.OpenUrl(url, frame)
		End Sub

		Private Function GetCommand(ByVal commandName As String) As ImageCommand
			Dim command As ImageCommand = Nothing
			Return command
		End Function

		Private Function ParseInt(ByVal s As String) As Integer
			Try
				Return Int32.Parse(s)
			Catch e1 As System.Exception
				Throw New ArgumentException(s & " is not a valid number.")
			End Try
		End Function

		' turns a color into its HTML equivalent
		Private Function FormatColor(ByVal c As Color) As String
			Dim colorList As PropertyInfo() = GetType(Color).GetProperties()

			For Each color As PropertyInfo In colorList
				If color.PropertyType.Equals(GetType(Color)) Then
					Dim knownColor As Color = CType(color.GetValue(Nothing, Nothing), Color)
					If c.R = knownColor.R AndAlso c.G = knownColor.G AndAlso c.B = knownColor.B AndAlso c.A = knownColor.A Then
						Return color.Name
					End If
				End If
			Next color
			If c.A < 255 Then
				Return String.Format("#{0:X2}{1}", c.A, ColorTranslator.ToHtml(c).Substring(1))
			End If
			Return String.Format("#{0}", ColorTranslator.ToHtml(c).Substring(1))
		End Function

		Private Function ParseColor(ByVal s As String) As Color
			Try
				Return ColorTranslator.FromHtml(s)
			Catch e1 As System.Exception
			End Try
			Try
				Return ColorTranslator.FromHtml("#" & s)
			Catch e2 As System.Exception
				Throw New ArgumentException(s & " is not a valid color.")
			End Try
		End Function

#End Region

#Region "Creating Annotations"

		' Method called from Page_Load to setup some basic annotations for creation from JavaScript
		Private Sub InitializeDefaultAnnotations()
			Dim ellipse As New EllipseData()
			ellipse.Name = "DefaultEllipse"
			ellipse.Outline = New AnnotationPen(Color.Black, 10)
			ellipse.Fill = New AnnotationBrush(Color.Red)
			ellipse.ToolTip = "Double-click to edit"
			WebAnnotationViewer1.Annotations.DefaultAnnotations.Add(ellipse)

			Dim highlighter As New RectangleData()
			highlighter.Name = "DefaultHighlighter"
			highlighter.Outline = New AnnotationPen(Color.Transparent, 1)
			highlighter.Fill = New AnnotationBrush(Color.FromArgb(128, Color.Yellow))
			WebAnnotationViewer1.Annotations.DefaultAnnotations.Add(highlighter)

			Dim line As New LineData()
			line.Name = "DefaultLine"
			line.Outline = New AnnotationPen(Color.DarkGreen, 6)
			WebAnnotationViewer1.Annotations.DefaultAnnotations.Add(line)

			Dim lines = New LinesData()
			lines.Name = "DefaultLines"
			lines.Outline = New AnnotationPen(Color.DarkOrange, 6)
			WebAnnotationViewer1.Annotations.DefaultAnnotations.Add(lines)

			Dim freehand As New FreehandData()
			freehand.Name = "DefaultFreehand"
			freehand.Outline = New AnnotationPen(Color.DarkBlue, 6)
			WebAnnotationViewer1.Annotations.DefaultAnnotations.Add(freehand)

			Dim polygon As New PolygonData()
			polygon.Name = "DefaultPolygon"
			polygon.Outline = New AnnotationPen(Color.MidnightBlue, 10)
			polygon.Fill = New AnnotationBrush(Color.FromArgb(192, Color.MidnightBlue))
			WebAnnotationViewer1.Annotations.DefaultAnnotations.Add(polygon)

			Dim rectangle As New RectangleData()
			rectangle.Name = "DefaultRectangle"
			rectangle.Outline = New AnnotationPen(Color.Sienna, 10)
			rectangle.Fill = New AnnotationBrush(Color.Plum)
			WebAnnotationViewer1.Annotations.DefaultAnnotations.Add(rectangle)

			Dim redaction As New RectangleData()
			redaction.Name = "DefaultRedaction"
			redaction.Fill = New AnnotationBrush(Color.Black)
			redaction.CanMove = False
			redaction.CanResize = False
			WebAnnotationViewer1.Annotations.DefaultAnnotations.Add(redaction)

			Dim sticky As New TextData()
			sticky.Name = "DefaultStickyNote"
			sticky.Fill = New AnnotationBrush(Color.Yellow)
			sticky.Shadow = New AnnotationBrush(Color.FromArgb(128, 0, 0, 0))
			sticky.ShadowMode = ShadowMode.Annotation
			sticky.ShadowOffset = New PointF(6, 6)
			sticky.Text = "Default Sticky Note:\n double-click to edit note"
			sticky.Font = New AnnotationFont("Verdana", 32.0F)
			sticky.Font.Bold = True
			WebAnnotationViewer1.Annotations.DefaultAnnotations.Add(sticky)

			Dim text = New TextData()
			text.Name = "DefaultTextAnnotation"
			text.Text = "Default Text Annotation:" + vbNewLine + "double-click to edit"
			text.Font = New AnnotationFont("Arial", 24.0F)
			text.FontBrush = New AnnotationBrush(Color.Black)
			text.Fill = New AnnotationBrush(Color.Ivory)
			text.Outline = New AnnotationPen(New AnnotationBrush(Color.White), 2)
			WebAnnotationViewer1.Annotations.DefaultAnnotations.Add(text)

			Dim stamp As New ReferencedImageData()
			stamp.Name = "DefaultStamp"
			stamp.FileName = Page.MapPath("SampleImages/draft.png")
			WebAnnotationViewer1.Annotations.DefaultAnnotations.Add(stamp)
		End Sub



#End Region

	End Class

End Namespace
