Imports Microsoft.VisualBasic
Imports System
Imports System.Collections
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Web
Imports System.Web.SessionState
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports System.Web.UI.HtmlControls
Imports Atalasoft.Imaging
Imports Atalasoft.Imaging.Codec
Imports Atalasoft.Imaging.WebControls
Imports Atalasoft.Imaging.ImageProcessing
Imports Atalasoft.Imaging.ImageProcessing.Effects
Imports Atalasoft.Imaging.ImageProcessing.Filters
Imports Atalasoft.Imaging.ImageProcessing.Transforms

Namespace DotImageWebFormsDemo
	Partial Class WebControlsSimpleDemo : Inherits System.Web.UI.Page

		Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load
			' Sets the default image upon initial page load.
			If (Not Page.IsPostBack) Then
				WebImageViewer1.OpenUrl("SampleImages/Chaotic_Light_3D.jpg")
			End If
		End Sub

		Protected Sub Button1_Click(ByVal sender As Object, ByVal e As System.EventArgs)
			' Loads the file from the browser's input stream, if it exists.
			If File1.PostedFile.FileName.Length <> 0 Then
				WebImageViewer1.Open(File1.PostedFile.InputStream)
			Else
				Label1.Text = "Error: You must specify a file name."
			End If
		End Sub

#Region "Remote Invokes"

		<RemoteInvokable()> _
		Public Sub CropSelection()
			' Make sure the selection is > 0
			If (Not WebImageViewer1.Selection.Rectangle.Size.IsEmpty) Then
				' Crops the image to the selection
				WebImageViewer1.ApplyCommand(New CropCommand(WebImageViewer1.Selection.Rectangle))

				' Resets the RubberBand
				WebImageViewer1.Selection.Reset()
			End If
		End Sub

		<RemoteInvokable()> _
		Public Sub EmbossSelection()
			' Creates a new Emboss command
			Dim myEmboss As EmbossCommand = New EmbossCommand(45, 10, 10)

			' Specifies a region to emboss if the selection is not empty
			If (Not WebImageViewer1.Selection.Rectangle.Size.IsEmpty) Then
				myEmboss.RegionOfInterest = New RegionOfInterest(WebImageViewer1.Selection.Rectangle)
			End If

			' Embosses the image
			WebImageViewer1.ApplyCommand(myEmboss)
		End Sub

#End Region

	End Class
End Namespace
