Imports Microsoft.VisualBasic
Imports System
Imports System.Collections
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.IO
Imports System.Web
Imports System.Web.SessionState
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports System.Web.UI.HtmlControls

Imports Atalasoft.Imaging
Imports Atalasoft.Imaging.Codec
Imports Atalasoft.Imaging.Drawing
Imports Atalasoft.Imaging.WebControls
Imports Atalasoft.Imaging.ImageProcessing
Imports Atalasoft.Imaging.ImageProcessing.Channels
Imports Atalasoft.Imaging.ImageProcessing.Transforms
Imports Atalasoft.Imaging.ImageProcessing.Effects
Imports Atalasoft.Imaging.ImageProcessing.Filters

Namespace DotImageWebFormsDemo
	Partial Class WebControlsMultiDemo : Inherits System.Web.UI.Page

		Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
			' Location of the image files (not resources)
			Dim pathPrefix = "SampleImages/"

			' If this page is a new one, pre-load an image from the resources folder
			If (Not Me.IsPostBack) Then
				Me.WebImageViewerMain.OpenUrl(pathPrefix & "Rosebud.jpg")
				Me.WebImageViewerPreview.OpenUrl(pathPrefix & "Rosebud.jpg")
			End If

		End Sub

#Region "Remote Invokes"

		' Process the image, and use a selected region if it exists
		<RemoteInvokable()> _
		Public Sub Process_Region(ByVal selectedValue As String)
			Try
				If selectedValue.Equals("Crop") Then
					If Me.WebImageViewerMain.Selection.Rectangle.Size <> Size.Empty Then
						WebImageViewerMain.ApplyCommand(New CropCommand(Me.WebImageViewerMain.Selection.Rectangle))
						Me.WebImageViewerMain.Selection.Reset()
					End If
				Else
					' Create a new command based on the user's selection
					Dim command As ImageRegionCommand = CType(GetCommand(selectedValue), ImageRegionCommand)

					' Check if there is a selection, and apply the selected area to the command if it exists
					If Me.WebImageViewerMain.Selection.Rectangle.Size <> Size.Empty Then
						command.RegionOfInterest = New RegionOfInterest(Me.WebImageViewerMain.Selection.Rectangle)
					End If

					WebImageViewerMain.ApplyCommand(command)
				End If
			Catch e1 As Exception
			End Try
		End Sub

		' Process the entire image, ignoring the selection
		<RemoteInvokable()> _
		Public Sub Process_Image(ByVal selectedValue As String)
			' Create a new command based on the user's selection
			Dim command As ImageCommand = GetCommand(selectedValue)

			Try
				WebImageViewerMain.ApplyCommand(command)
				' Flatten the Alpha channel if one was created so we can see it in the browser
				If PixelFormatUtilities.HasAlpha(WebImageViewerMain.Image.PixelFormat) = True Then
					WebImageViewerMain.ApplyCommand(New FlattenAlphaCommand(Color.White))
				End If
			Catch e1 As Exception
			End Try
		End Sub

		' Process the color depth change
		<RemoteInvokable()> _
		Public Sub Process_Color(ByVal selectedValue As String)
			Dim command As ImageCommand

			' Create a command based on the user selection
			Select Case selectedValue

				Case "Paletted"	' Indexed pallete
					command = New ChangePixelFormatCommand(PixelFormat.Pixel8bppIndexed)
				Case "Greyscale" ' Grayscale
					command = New ChangePixelFormatCommand(PixelFormat.Pixel8bppGrayscale)
				Case "BW" ' Black and white
					command = New ApplyPaletteCommand(New Palette(Color.Black, Color.White), DitheringMode.FloydSteinberg)
					'Case "RGB"
				Case Else ' 24bit color
					command = New ChangePixelFormatCommand(PixelFormat.Pixel24bppBgr)
			End Select

			Try
				WebImageViewerMain.ApplyCommand(command)
			Catch e1 As Exception
			End Try
		End Sub

		<RemoteInvokable()> _
		Public Sub Draw_Selection(ByVal selectedValue As String, ByVal fill As Boolean, ByVal alpha As Boolean)
			Dim myCanvas As Canvas = New Canvas(Me.WebImageViewerMain.Image)
			Dim mySelection As Rectangle = Me.WebImageViewerMain.Selection.Rectangle

			Select Case selectedValue
				Case "rectangle"
					If fill Then
						If alpha Then
							myCanvas.DrawRectangle(mySelection, New AtalaPen(Color.Black), New SolidFill(Color.FromArgb(128, Color.DarkOrange)))
						Else
							myCanvas.DrawRectangle(mySelection, New AtalaPen(Color.Black), New SolidFill(Color.Orange))
						End If
					Else
						If alpha Then
							myCanvas.DrawRectangle(mySelection, New AtalaPen(Color.FromArgb(128, Color.Black)))
						Else
							myCanvas.DrawRectangle(mySelection, New AtalaPen(Color.Black))
						End If
					End If

					Me.WebImageViewerMain.Selection.Reset()

				Case "circle"
					If fill Then
						If alpha Then
							myCanvas.DrawEllipse(mySelection, New AtalaPen(Color.Black), New SolidFill(Color.FromArgb(128, Color.DarkOrange)))
						Else
							myCanvas.DrawEllipse(mySelection, New AtalaPen(Color.Black), New SolidFill(Color.Orange))
						End If
					Else
						If alpha Then
							myCanvas.DrawEllipse(mySelection, New AtalaPen(Color.FromArgb(128, Color.Black)))
						Else
							myCanvas.DrawEllipse(mySelection, New AtalaPen(Color.Black))
						End If
					End If

					Me.WebImageViewerMain.Selection.Reset()

				Case "text"
					Dim myFont As Font = New Font(Me.WebImageViewerMain.Font.Name, 30)

					If fill Then
						If alpha Then
							myCanvas.DrawText("Atalasoft", mySelection, myFont, New SolidFill(Color.Black), New SolidFill(Color.FromArgb(128, Color.DarkOrange)), New TextFormat(TextAlignment.Left))
						Else
							myCanvas.DrawText("Atalasoft", mySelection, myFont, New SolidFill(Color.Black), New SolidFill(Color.Orange), New TextFormat(TextAlignment.Left))
						End If
					Else
						If alpha Then
							myCanvas.DrawText("Atalasoft", mySelection, myFont, New SolidFill(Color.FromArgb(128, Color.Black)))
						Else
							myCanvas.DrawText("Atalasoft", mySelection, myFont, New SolidFill(Color.Black))
						End If
					End If

					Me.WebImageViewerMain.Selection.Reset()

				Case "image"
					Dim workspace As Workspace = New Workspace()

					workspace.Image = New AtalaImage(Page.MapPath("SampleImages/") & "alpha_atala.png")
					workspace.ApplyCommand(New ResampleCommand(mySelection.Size, ResampleMethod.LanczosFilter))

					If fill Then
						If alpha Then
							myCanvas.DrawRectangle(mySelection, New AtalaPen(Color.Black), New SolidFill(Color.FromArgb(128, Color.DarkOrange)))
						Else
							myCanvas.DrawRectangle(mySelection, New AtalaPen(Color.Black), New SolidFill(Color.Orange))
						End If
					Else
						If (Not alpha) Then
							myCanvas.DrawRectangle(mySelection, New AtalaPen(Color.Black), New SolidFill(Color.White))
						End If
					End If

					Me.WebImageViewerMain.ApplyCommand(New OverlayCommand(workspace.Image, mySelection.Location))


					Me.WebImageViewerMain.Selection.Reset()

			End Select

			Me.WebImageViewerMain.Update()
		End Sub

#End Region

#Region "Functions"

		Private Function GetCommand(ByVal commandName As String) As ImageCommand
			Dim command As ImageCommand

			Select Case commandName
				Case "Crop"
					command = New CropCommand()
				Case "DropShadow"
					command = New DropShadowCommand(10)
				Case "Emboss"
					command = New EmbossCommand(135, 10, 10, False)
				Case "Threshold"
					command = New ThresholdCommand(24, 80)
				Case "UnsharpMask"
					command = New UnsharpMaskCommand(0, 1, 2.4)
				Case "Mosaic"
					command = New MosaicCommand(6)
				Case "Rotate90"
					command = New RotateCommand(90.0)
				Case "Rotate-90"
					command = New RotateCommand(-90.0)
				Case "FlipHorizontal"
					command = New FlipCommand(FlipDirection.Horizontal)
				Case "FlipVertical"
					command = New FlipCommand(FlipDirection.Vertical)
				Case Else
					command = New BlurGaussianCommand(3)
			End Select

			Return command
		End Function

#End Region

	End Class
End Namespace
