<%@ Page language="vb" Inherits="DotImageWebFormsDemo.WebControlsMultiDemo" CodeFile="WebControlsMultiDemo.aspx.vb" AutoEventWireup="false" %>
<%@ Register TagPrefix="cc1" Namespace="Atalasoft.Imaging.WebControls" Assembly="Atalasoft.dotImage.WebControls" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>DotImage WebForms Multi-Control Demo</title>
	<link href="WebControlsMultiDemo.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
    <div>
		<div class="title">Powered by: Atalasoft DotImage 7.0</div>
		<div class="menu">&nbsp;
    		<select id="DropDown_Image" class="dropdown" onchange="onDropDown_ImageChanged(this.value); this.selectedIndex=0;">
				<option value="-1" selected="selected">Working Image</option>
				<option value="SampleImages/butterfly.jpg">Butterfly</option>
				<option value="SampleImages/Chaotic_Light_3D.jpg">Chaotic Light</option>
				<option value="SampleImages/Rosebud.jpg">Rosebud</option>
				<option value="SampleImages/DocCleanMultipage.tif">Multipage Tiff</option>
				<option value="Upload">Upload Image</option>
			</select>
			<select id="DropDown_AutoZoom" class="dropdown" onchange="onDropDown_AutoZoomChanged(this.value); this.selectedIndex=0;">
				<option value="-1" selected="selected">AutoZoom</option>
				<option value="0">Full Image</option>
				<option value="1">Best Fit</option>
				<option value="2">Best Fit (Shrink)</option>
				<option value="3">Fit To Width</option>
				<option value="4">Fit To Height</option>
			</select>
			<select id="DropDown_MouseTool" class="dropdown" onchange="onDropDown_MouseToolChanged(this.value);">
				<option value="-1" selected="selected">Interactive Mode</option>
				<option value="0">None</option>
				<option value="6">Pan</option>
				<option value="1">Center on click</option>
				<option value="8">Draw with Selection</option>
				<option value="2">Selection</option>
				<option value="3">Zoom In</option>
				<option value="4">Zoom Out</option>
				<option value="5">Zoom Area</option>
				<option value="7">Zoom</option>
			</select>
			<select id="DropDown_DrawSelection" class="dropdown">
				<option value="rectangle" selected="selected">Draw Object</option>
				<option value="rectangle">Rectangle</option>
				<option value="circle">Ellipse</option>
				<option value="text">Text</option>
				<option value="image">Image</option>
			</select>
			<select id="DropDown_RegionOperationSelector" class="dropdown" onchange="remoteProcessRegion(this.value);this.selectedIndex=0;">
				<option value="0" selected="selected">Region Commands</option>
				<option value="Crop">Crop</option>
				<option value="Blur">Blur</option>
				<option value="UnsharpMask">Unsharp Mask</option>
				<option value="Emboss">Emboss</option>
			</select>
			<select id="DropDown_ImageOperationSelector" class="dropdown" onchange="remoteProcessImage(this.value);this.selectedIndex=0;">
				<option value="0" selected="selected">Image Commands</option>
				<option value="Threshold">Threshold</option>
				<option value="Mosaic">Mosaic</option>
				<option value="Rotate90">Rotate 90&#176;</option>
				<option value="Rotate-90">Rotate -90&#176;</option>
				<option value="FlipHorizontal">Flip Horizontal</option>
				<option value="FlipVertical">Flip Vertical</option>
				<option value="DropShadow">Drop Shadow</option>
			</select>
			<select id="DropDown_ColorOperationSelector" class="dropdown" onchange="remoteProcessColor(this.value);this.selectedIndex=0;">
				<option value="0" selected="selected">Change Color Depth</option>
				<option value="RGB">RGB (24-bit)</option>
				<option value="Paletted">Paletted (8-bit)</option>
				<option value="Greyscale">Greyscale (8-bit)</option>
				<option value="BW">Black &amp; White (1-bit)</option>
			</select>
			<input id="CheckBox_AntiAlias" type="checkbox" checked="checked" onclick="onCheckBox_AntiAliasChanged(this.checked);" /><font face="Verdana" size="1">Anti-alias Display</font>
		</div>
		<div class="body">
			<iframe id="ImageUploader" marginwidth="0" marginheight="0" src="WebControlsMultiDemo_ImageUploader.aspx" frameborder="0" width="300" height="30"></iframe>
			<div id="DrawOptions">
				<input id="CheckBox_Fill" type="checkbox" checked="checked" /><font face="Verdana" size="1">&nbsp;Fill objects</font>
				<input id="CheckBox_Alpha" type="checkbox" checked="checked" /><font face="Verdana" size="1">&nbsp;Use alpha fill</font>
			</div>
			<cc1:webimageviewer id="WebImageViewerMain" runat="server"
				antialiasdisplay="ReductionOnly" bordercolor="Black"
				backcolor="#E0E0E0"
				centered="True"
				scrollbarvisibility="None"
				height="600px"
				width="100%"
			/>
			<div class="thumb">
				<cc1:webimageviewer id="WebImageViewerPreview" runat="server"
					antialiasdisplay="ReductionOnly"
					autozoom="BestFit"
					centered="True"
					mousetool-leftbutton="None"
					scrollbarvisibility="None"
					selection-resizable="False"
					selection-visibility="Visible"
					height="120px"
					width="160px"
				/>
			</div>
		</div>
		<div id="tooltip">
			&nbsp;No MouseTool enabled. Use the Interactive Mode drop down menu to select one.
		</div>
	</div>

<script language="javascript" type="text/javascript">
<!--
	var _zoom = 1;			// Main zoom level
	var _vps = null;		// ViewPort size

	// DOM objects
	var _dropDown_DrawSelection = null;
	var _checkBox_Fill = null;
	var _checkBox_Alpha = null;
	var _label = null;
	var _drawOptions = null;
	var _imageUploader = null;

	var _mouseToolTips = [
		'&nbsp;No MouseTool enabled. Use the Interactive Mode drop down to select one.',
		'&nbsp;Left click anywhere on the image to re-center the control\'s position.',
		'&nbsp;Click and drag to make a rectangular selection. Click outside the selection to remove it.',
		'&nbsp;Left click anywhere on the image to zoom into that location.',
		'&nbsp;Left click anywhere on the image to zoom out from that location.',
		'&nbsp;Click and drag to make a rectangular selection. The area you select will be zoomed into.',
		'&nbsp;Left click and drag to pan the image.',
		'&nbsp;Left click anywhere on the image to zoom in, right click to zoom out.',
		'&nbsp;Click and drag to make a rectangular box. An object will be rendered onto the image.'
	]

	atalaInitClientScript(OnMultiDemoLoad);
	function OnMultiDemoLoad(){
		// window events
		window.onresize = onWindowResize;

		// main viewer events
		WebImageViewerMain.ScrollPositionChanged = onMainPositionChanged;
		WebImageViewerMain.ZoomChanged = onMainZoomChanged;
		WebImageViewerMain.ImageChanged = onImageChanged;
		WebImageViewerMain.RemoteInvoked = onRemoteInvoked;

		// thumb events
		WebImageViewerPreview.getSelection().Changing = onPreviewSelectionChanging;
		WebImageViewerPreview.ImageSizeChanged = sizeThumbSelection;

		// dom objects
		_dropDown_DrawSelection = document.getElementById('DropDown_DrawSelection');
		_checkBox_Fill = document.getElementById('CheckBox_Fill');
		_checkBox_Alpha = document.getElementById('CheckBox_Alpha');
		_label = document.getElementById('tooltip');
		_drawOptions = document.getElementById('DrawOptions');
		_imageUploader = document.getElementById('ImageUploader');

        // disable drawing tools for initial run
		_dropDown_DrawSelection.disabled = 'disabled';
		_checkBox_Fill.disabled = 'disabled';
		_checkBox_Alpha.disabled = 'disabled';

		// call this once to set up initial size
		onWindowResize();
	}

	// handles a window resize, since the Main viewer width is dynamic	
	function onWindowResize(){
		// It's possible to resize the height of the Main WebImageViewer here, so 
		// that the height can be dynamic too.  However, there are major differences
		// in the way that 100% height is interpreted by different browsers.  
		_vps = WebImageViewerMain.getViewPortSize();
		sizeThumbSelection();
	}

	// Sets the thumb control's selection location based on scroll position
	function onMainPositionChanged(){
		var sp = WebImageViewerMain.getScrollPosition();
		sp.X = Math.round(-sp.X / _zoom);
		sp.Y = Math.round(-sp.Y / _zoom);
		WebImageViewerPreview.getSelection().setPosition(sp);
	}

	// Sets the main control's scroll position based on the selection postion
	function onPreviewSelectionChanging(){
		var pp = WebImageViewerPreview.getSelection().getPosition();
		pp.X = Math.round(-pp.X * _zoom);
		pp.Y = Math.round(-pp.Y * _zoom);
		WebImageViewerMain.setScrollPosition(pp);
	}

	// Sets the other control's selection size based on the Zoom of the Main
	function onMainZoomChanged(){
		_zoom = WebImageViewerMain.getZoom();
        sizeThumbSelection();
	}

	// Sets the size of the thumb's selection box, with respect to the current zoom and viewport size
	function sizeThumbSelection(){
		var vp = WebImageViewerMain.getViewPortSize();
		vp.Width = Math.round(vp.Width / _zoom);
		vp.Height = Math.round(vp.Height / _zoom);
		WebImageViewerPreview.getSelection().setSize(vp);
	}

	// Opens the selected image
	function onDropDown_ImageChanged(val){
		if (val == 'Upload'){
			_imageUploader.style.visibility = 'visible';
		}
		else{
			_imageUploader.style.visibility = 'hidden';
			WebImageViewerMain.OpenUrl(val);
		}
	}

	// Opens the new image in the preview
	function onImageChanged(){
		WebImageViewerPreview.OpenUrl(WebImageViewerMain.getImageUrl());
	}

	// Sets the autozoom, defaulting to 1:1 when zero
	function onDropDown_AutoZoomChanged(val){
		WebImageViewerMain.setAutoZoom(val);
		if (val == 0){
			WebImageViewerMain.setZoom(1);
		}
	}

	// Changes the mouse tool, and staus bar tip
	function onDropDown_MouseToolChanged(val){
		if (val <= 0 && val < _mouseToolTips.length){
			_label.innerHTML = _mouseToolTips[val];
		}
	
		if (val == 7){	// Zoom requires two mouse buttons
			WebImageViewerMain.setMouseTool(3, 4);
		}
		else{
			WebImageViewerMain.setMouseTool(val, 0);
		}
	
		if (val == 8){	// Draw with selection box
			WebImageViewerMain.setMouseTool(2, 0);
			
			_drawOptions.style.visibility = 'visible';
			_dropDown_DrawSelection.disabled = '';
			_checkBox_Fill.disabled = '';
			_checkBox_Alpha.disabled = '';

			WebImageViewerMain.getSelection().setMultiColor(false);
			WebImageViewerMain.getSelection().Changed = remoteDrawSelection;
		}
		else{
			_drawOptions.style.visibility = 'hidden';
			WebImageViewerMain.getSelection().setMultiColor(true);
			WebImageViewerMain.getSelection().Changed = function(){};

			_dropDown_DrawSelection.disabled = 'disabled';
			_checkBox_Fill.disabled = 'disabled';
			_checkBox_Alpha.disabled = 'disabled';
		}
	}

	// Asynchronously processes the entire image based on the input command
	function remoteProcessImage(val){
		var a = new Array();
			a.push(val);

		WebImageViewerMain.RemoteInvoke('Process_Image', a);
	}

	// Asynchronously processes selected region of the image based on the input command
	function remoteProcessRegion(val){
		var a = new Array();
			a.push(val);

		WebImageViewerMain.RemoteInvoke('Process_Region', a);
	}

	// Asynchronously processes the image, changing the color depth, based on the input command
	function remoteProcessColor(val){
		var a = new Array();
			a.push(val);

		WebImageViewerMain.RemoteInvoke('Process_Color', a);
	}

	// Asynchronously processes the image, drawing an object within the selection bounds
	function remoteDrawSelection(){
		var a = [
			_dropDown_DrawSelection.value,
			_checkBox_Fill.checked,
			_checkBox_Alpha.checked
		];

    	// Check if the selection is visible, since the server side function hides the selection box
		if (WebImageViewerMain.getSelection().getVisible()){
			WebImageViewerMain.RemoteInvoke('Draw_Selection', a);
		}
	}
	
	// Checks for errors after remote invokes
	function onRemoteInvoked(){
	    var err = WebImageViewerMain.getReturnValue();
	    if (err != ''){
	        onError(err);
	    }
	}

	// Changes the antialias display mode
	function onCheckBox_AntiAliasChanged(val){
		if(val){
			WebImageViewerMain.setAntialiasDisplay(2);
		}
		else{
			WebImageViewerMain.setAntialiasDisplay(0);
		}
	}

	// Do something with errors
	function onError(err){
	    alert(err);
	}
-->
</script>

	</form>

</body>
</html>
